/****************************************************************************
File    : misc_win.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# MiscWin public methods and objects prototypes
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 24.06.2001
*/

#ifndef __MISC_WIN_H__
#define __MISC_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define MS_FULL_SPEED				0x00000001 /* Misc states to be saved out to the Registry */
#define MS_AUTO_REG_FILES			0x00000002
#define MS_LAST_BOOT_FAILED			0x00000004
#define MS_MOUSE_CAPTURED			0x00000008
#define MS_STICK_RELEASE			0x00000010
#define MS_USE_KEY_TEMPLATE			0x00000020
#define MS_RAMBO_MODE				0x00000040
#define MS_USE_EXT_PALETTE			0x00000080
#define MS_SHOW_PEN_POINTER			0x00000100
#define MS_JOY_FIRE_ONLY			0x00000200
#define MS_REUSE_WINDOW				0x00000400
#define MS_CAPTURE_CTRLESC			0x00000800
#define MS_USE_DOUBLE_REFRESH		0x00001000
#define MS_TRANS_LOADED_PAL			0x00002000
#define MS_USE_PRINT_COMMAND		0x00004000
#define MS_SHOW_DRIVE_LED			0x00008000
#define MS_STOP_WHEN_NO_FOCUS		0x00010000
#define MS_ALLOW_OPPOSITE_KEYS		0x00020000
#define MS_SHOW_INDICATORS			0x00040000
#define MS_NO_COLLISIONS			0x00080000
#define MS_HIGH_PRIORITY			0x00100000
#define MS_CONFIRM_ON_EXIT			0x00200000

#define DEF_MISC_STATES				(MS_STICK_RELEASE | MS_ALLOW_OPPOSITE_KEYS | MS_STOP_WHEN_NO_FOCUS | MS_SHOW_DRIVE_LED | MS_SHOW_INDICATORS | MS_CONFIRM_ON_EXIT)
#define DEF_DONT_SHOW_FLAGS			0L
#define DEF_FILE_ASSOCIATIONS		0L

#define DONT_SHOW_GRAPHICS_WARN		0x0001 /* "Don't show" warning flags */
#define DONT_SHOW_SOUNDFILE_WARN	0x0002
#define DONT_SHOW_MENU_WARN			0x0004
#define DONT_SHOW_OSA_WARN			0x0008
#define DONT_SHOW_OSB_WARN			0x0010
#define DONT_SHOW_XLXE_WARN			0x0020
#define DONT_SHOW_5200_WARN			0x0040
#define DONT_SHOW_BASIC_WARN		0x0080
#define DONT_SHOW_VBLWAIT_WARN		0x0100
#define DONT_SHOW_KBJOY_WARN		0x0200
#define DONT_SHOW_VIDEOFILE_WARN	0x0400

#define IAF_BIN_IMAGE				0x01
#define IAF_DSK_IMAGE				0x02
#define IAF_CRT_IMAGE				0x04
#define IAF_ROM_IMAGE				0x08
#define IAF_A8S_IMAGE				0x10
#define IAF_ATARI_FILE				0xff

#define SYS_WIN_95					0x0001
#define SYS_WIN_98					0x0002
#define SYS_WIN_9x					0x000f
#define SYS_WIN_NT4					0x0010
#define SYS_WIN_NT5					0x0020
#define SYS_WIN_NT					0x00f0
#define SYS_PRC_MMX					0x0100
#define SYS_PRC_3DN					0x0200
#define SYS_PRC_SSE					0x0400
#define SYS_PRC_EN					0x0f00

#define ROM_TYPES_NO				5

/* Exported types */

enum RomType { RTI_OSA = 0, RTI_OSB, RTI_XLE, RTI_A52, RTI_BAS };

struct RomTypeInfo_t
{
	enum   RomType rtType;
	ULONG  ulCRC;
	LPCSTR pszDesc;		/* The pointer to a static text */
};

/* Exported methods */

void  Misc_ToggleFullSpeed    ( void );
void  Misc_TogglePause        ( void );
void  Misc_ToggleSIOPatch     ( void );
BOOL  Misc_AllocMonitorConsole( FILE **pOutput, FILE **pInput );
void  Misc_FreeMonitorConsole ( FILE *pOutput, FILE *pInput );
int   Misc_LaunchMonitor      ( void );
BOOL  Misc_TestRomPaths       ( LPSTR pszStartPath, HWND hWnd );
int	  Misc_FindCartType       ( LPCSTR pszFileName, BOOL bAutoDetect, BOOL bCheckExt );
BOOL  Misc_IsAtariFile        ( LPCSTR pszFileName, UINT *pFileType );
BOOL  Misc_IsCompressedFile   ( LPCSTR pszFileName );
BOOL  Misc_RunAtariExe        ( LPSTR pszFileName );
BOOL  Misc_GetHomeDirectory   ( LPSTR pszHomeDir );
void  Misc_GetFolderPath      ( LPSTR pszPathName, LPSTR pszFileName );
HWND  Misc_FindAppWindow      ( void );
BOOL  Misc_GetSystemInfo      ( UINT *pSystemInfo );
BOOL  Misc_ExecutePrintCmd    ( LPSTR pszPrintFile );
void  Misc_SetProcessPriority ( void );
/* These ones are invoked directly by kernel */
int   Atari_Exit              ( int nPanic );
int   zlib_capable            ( void );

/* Exported globals */

struct MiscCtrl_t
{
	ULONG ulState;				/* Emulator state flags */
	ULONG ulFileAssociations;
	ULONG ulDontShow;			/* "Do not show" flags  */
	UINT  unSystemInfo;
};
extern struct MiscCtrl_t g_Misc;

extern const int g_nRomTypeInfoNo;

extern struct RomTypeInfo_t g_aRomTypeInfo[];

#ifdef __cplusplus
}
#endif

#endif /*__MISC_WIN_H__*/
