/****************************************************************************
File    : macros.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Usefull macros declarations
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 24.06.2001
*/

#ifndef __MACROS_H__
#define __MACROS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* State of the emulator */

#define ST_DOUBLE_REFRESH \
	(g_Misc.ulState & MS_USE_DOUBLE_REFRESH && \
	 g_Screen.ulMode & SM_MODE_WIND && \
	 g_Screen.ulMode & SM_WRES_DOUBLE)

#define ST_MENUBAR_HIDDEN \
	(g_Screen.ulMode & SM_MODE_FULL && \
	(g_Screen.ulMode & (SM_OPTN_FLIP_BUFFERS | SM_ATTR_NO_MENU)))

#define ST_DOUBLE_BUFFERS \
	(g_Screen.ulMode & SM_MODE_FULL && \
	 g_Screen.ulMode & SM_OPTN_FLIP_BUFFERS)

#define ST_ATARI_STOPPED \
	(g_ulAtariState & (ATARI_UNINITIALIZED | ATARI_CRASHED | ATARI_PAUSED))

#define ST_ATARI_FAILED \
	(g_ulAtariState & (ATARI_UNINITIALIZED | ATARI_CRASHED))

#define ST_MENU_VISIBLE \
	(g_Screen.bLocked || !ST_MENUBAR_HIDDEN || ST_ATARI_STOPPED)

#ifdef __cplusplus
}
#endif

#endif /*__MACROS_H__*/
