/****************************************************************************
File    : input_win.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# InputWin public methods and objects prototypes
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 03.02.2001
*/

#ifndef __INPUT_WIN_H__
#define __INPUT_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define MAX_INPUT_DEVICES		8
#define MAX_ATARI_JOYPORTS		4
#define NUM_KBJOY_DEVICES		4
#define NUM_KBJOY_KEYS			10
#define INPUT_DEV_NAMELEN		32

#define NUMPAD_JOYSTICK			-4
#define CURSOR_JOYSTICK			-3
#define KEYS_A_JOYSTICK			-2
#define KEYS_B_JOYSTICK			-1
/*								...
Found input devs here			(0, ..., MAX_INPUT_DEVICES - 1)
*/
#define NO_JOYSTICK				127

#define TIMER_READ_JOYSTICK		6969
										/* Warning: See special keys */
#define SPECIAL_HANDLER_MASK	0xf000	/* codes in atari.h file!    */
#define AKEY_OPTIONDWN			0xffe1
#define AKEY_SELECTDWN			0xffe2
#define AKEY_STARTDWN			0xffe3
#define AKEY_OPTIONUP			0xffe7
#define AKEY_SELECTUP			0xffe8
#define AKEY_STARTUP			0xffe9
#define AKEY_MONITOR			0xffea

#define KEYSET_NW				0
#define KEYSET_NORTH			1
#define KEYSET_NE				2
#define KEYSET_EAST				3
#define KEYSET_SE				4
#define KEYSET_SOUTH			5
#define KEYSET_SW				6
#define KEYSET_WEST				7
#define KEYSET_CENTRE			8
#define KEYSET_FIRE				9
								  /* Mouse emulating modes   */
#define MOUSE_OFF				0	/* Mouse emulation off   */
#define MOUSE_PAD				1	/* Paddles               */
#define MOUSE_TOUCH				2	/* Atari touch tablet    */
#define MOUSE_KOALA				3	/* Koala pad             */
#define MOUSE_PEN				4	/* Light pen/light gun   */
#define MOUSE_AMIGA				5	/* Amiga mouse           */
#define MOUSE_ST				6	/* Atari ST mouse        */
#define MOUSE_JOY				7	/* Joystick              */
								  /* Autofire modes          */
#define AUTOFIRE_OFF			0	/* Autofire off          */
#define AUTOFIRE_FIRE			1	/* Fire dependent        */
#define AUTOFIRE_CONT			2	/* Continuous            */
								  /* Arrow keys modes        */
#define ARROWKEYS_CTRLARROWS	0	/* Control + arrows      */
#define ARROWKEYS_ARROWS		1	/* Arrows only           */
#define ARROWKEYS_F1F4			2	/* Function keys         */

#define DEF_AUTOFIRE_MODE		AUTOFIRE_OFF
#define DEF_MOUSE_MODE			MOUSE_OFF
#define DEF_PEN_OFFSET_X		0
#define DEF_PEN_OFFSET_Y		0
#define DEF_MOUSE_PORT			0
#define DEF_MOUSE_SPEED			5
#define DEF_PADDLE_RANGE		228
#define DEF_JOY_INERTIA			5
#define DEF_ARROWS_MODE			ARROWKEYS_ARROWS
#define DEF_JOY_SELECTS			0x7f7f7ffc
#define DEF_AUTOFIRE_STICKS		0x0f

#define CTRL_KEY				g_Input.Key.nCtrlKey

/* Exported methods */

int  Input_Initialise         ( BOOL bInitDInput );
void Input_Reset              ( void );
void Input_Clear              ( void );
int  Input_ReadJoystick       ( int nStickNum, BOOL bButton );
void Input_GetJoystick        ( void );
BOOL Input_ToggleKeyDown      ( WPARAM wp, LPARAM lp );
BOOL Input_ToggleKeyUp        ( WPARAM wp, LPARAM lp );
void Input_ToggleMouseCapture ( void );
void Input_ResetKeys          ( void );
void Input_UpdateMouseState   ( void );
void Input_ResetMouse         ( BOOL bCenter );
void Input_EnableEscCapture   ( BOOL bEnable );
void Input_InstallKeyboardHook( BOOL bEnable );
void Input_RefreshBounds      ( HWND hViewWnd, BOOL bClipCursor );
/* This one is invoked directly by kernel */
int  Atari_Keyboard           ( void );

/* Exported globals */

struct InputCtrl_t
{
	int  anDevSelected[ MAX_ATARI_JOYPORTS ];
	char acDevNames   [ MAX_INPUT_DEVICES ][ INPUT_DEV_NAMELEN ];
	int  nDevFoundNum;
	/* Joystick */
	struct JoyCtrl_t
	{
		ULONG ulSelected;
		ULONG ulAutoSticks;
		int   nAutoMode;
		BOOL  bKBJoystick;
		WORD (*anKeysets)[ NUM_KBJOY_KEYS ];
	} Joy;
	/* Keyboard */
	struct KeyCtrl_t
	{
		int   nArrowsMode;
		int   nCurrentKey;
		int   nCurrentVK;
		int   nNewKey;
		int   nNewVK;
		int   nCtrlKey;
		BYTE *anExtKeys;
	} Key;
	/* Mouse */
	struct MouseCtrl_t
	{
		int   nMode;
		int   nPort;
		int   nX;
		int   nY;
		int   nButtons;
		int   nMouseSpeed;
		int   nPenOffsetX;
		int   nPenOffsetY;
		int   nPaddleRange;
		int   nJoyInertia;
	} Mouse;
};
extern struct InputCtrl_t g_Input;

#ifdef __cplusplus
}
#endif

#endif /*__INPUT_WIN_H__*/
