/****************************************************************************
File    : globals.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Shared C-core attributes declarations
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 16.03.2001
*/

#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Shared C-core specific const definitions */

#define ATARI_UNINITIALIZED		0x0001	/* Various machine states the Atari can be in */
#define ATARI_RUNNING			0x0002
#define ATARI_PAUSED			0x0004
#define ATARI_NO_FOCUS			0x0008
#define ATARI_LOAD_FAILED		0x0010
#define ATARI_CRASHED			0x0020
#define ATARI_CLOSING			0x0040
#define ATARI_MONITOR			0x0080

#define DEF_START_X				0		/* Default values */
#define DEF_START_Y				0
#define DEF_DOUBLE_RATE			2
#define DEF_SPEED_PERCENT		100

#define CX_BORDER				2		/* Note: afxData.cxBorder and afxData.cyBorder aren't used anymore */
#define CY_BORDER				2

#define LOADSTRING_STRING_SIZE	1024
#define TEMPLATE_DESC_LENGTH	256

#define ID_INDICATOR_MSG		0
#define ID_INDICATOR_RUN		1
#define ID_INDICATOR_VID		2
#define ID_INDICATOR_SIO		3
#define ID_INDICATOR_MSE		4
#define ID_INDICATOR_JOY		5
#define ID_INDICATOR_AVI		6
#define ID_INDICATOR_WAV		7

/* AtariWin C modules shared objects */

extern LPCSTR VERSION_INFO;

extern LPCSTR DEFAULT_A8S;
extern LPCSTR DEFAULT_A8K;
extern LPCSTR DEFAULT_ACT;
extern LPCSTR DEFAULT_OSA;
extern LPCSTR DEFAULT_OSB;
extern LPCSTR DEFAULT_OXL;
extern LPCSTR DEFAULT_O52;
extern LPCSTR DEFAULT_BAS;
extern LPCSTR DEFAULT_HDD;

extern HWND      g_hMainWnd;
extern HWND      g_hViewWnd;
extern HINSTANCE g_hInstance;

extern int       g_nStartX;
extern int       g_nStartY;
extern int       g_nTestVal;
extern int       g_nDoubleRate;
extern int       g_nSpeedPercent;

extern ULONG     g_ulAtariState;

extern int       g_argc;
extern char     *g_argv          [];
extern char      g_szCmdLine     [];

extern char      g_szCurrentRom  [];
extern char      g_szOtherRom    [];
extern char      g_szTemplateFile[];
extern char      g_szTemplateDesc[];
extern char      g_szPaletteFile [];

#ifdef __cplusplus
}
#endif

#endif /*__GLOBALS_H__*/
