/****************************************************************************
File    : Helpers.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Global declaration of usefull methods and objects
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 24.06.2001
*/

#ifndef __HELPERS_H__
#define __HELPERS_H__

#ifdef __cplusplus

/*
   C++ specific declarations
*/

/* File management */

#define PF_LOAD_FLAGS	(OFN_EXPLORER | OFN_HIDEREADONLY | OFN_FILEMUSTEXIST)
#define PF_SAVE_FLAGS	(OFN_EXPLORER | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT)

extern LPCSTR  PF_DSK_FILTER;
extern LPCSTR  PF_BIN_FILTER;
extern LPCSTR  PF_A8S_FILTER;
extern LPCSTR  PF_A8K_FILTER;
extern LPCSTR  PF_ACT_FILTER;
extern LPCSTR  PF_PCX_FILTER;
extern LPCSTR  PF_WAV_FILTER;
extern LPCSTR  PF_CRT_FILTER;
extern LPCSTR  PF_ROM_FILTER;
extern LPCSTR  PF_CAR_FILTER;
extern LPCSTR  PF_TXT_FILTER;
extern LPCSTR  PF_AVI_FILTER;
extern LPCSTR  PF_DCM_FILTER;
extern LPCSTR  PF_XFD_FILTER;
extern LPCSTR  PF_ATR_FILTER;

BOOL PickFileName( BOOL bOpenFileDialog, LPSTR pszFileName, LPCSTR pszTitle, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );
BOOL PickFileName( BOOL bOpenFileDialog, CString &strFileName, LPCSTR pszTitle, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None", CWnd *pParentWnd = NULL );

/* Cartridge management */

BOOL PickCartridge  ( LPSTR pszCurrentCart, CWnd *pParentWnd = NULL );
BOOL AttachCartridge( LPSTR pszCartridge, int nCartType );

/* Hooks procedures */

UINT CALLBACK FileDialogHookProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );

/* Miscellanous */

void RestartEmulation( BOOL bForceWinInit = TRUE, BOOL bIgnoreParams = TRUE );

extern BOOL g_bLargeFonts;

#endif /*__cplusplus*/

#ifdef __cplusplus
extern "C" {
#endif

/*
   Common declarations
*/

void UpdateIndicator( int nPane );

#ifdef __cplusplus
}
#endif


#endif /*__HELPERS_H__*/
