/****************************************************************************
File    : atari800.h
/*
@(#) #SY# Atari800Win PLus
@(#) #IS# Shared Atari800 methods and objects declarations
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 15.10.2000
*/

#ifndef __ATARI800_H__
#define __ATARI800_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Atari800 exports we are using in the Win project */

#include "atari.h"
#include "antic.h"
#include "cpu.h"
#include "sio.h"
#include "pokeysnd.h"
#include "pokey.h"
#include "ui.h"
#include "statesav.h"
#include "binload.h"
#include "log.h"
#include "diskled.h"
#include "colours.h"
#include "ataripcx.h"
#include "rt-config.h"
#include "monitor.h"

/* I haven't found any header files for these exports */

extern int cart_type;
extern int rom_inserted;
extern int stereo_enabled;
extern int test_val;
extern int pil_on;
extern int SHIFT_KEY;
extern int KEYPRESSED;

extern UBYTE      memory      [];
extern UBYTE      atari_basic [];
extern UnitStatus drive_status[];
extern int        TRIG_auto   [];		/* autofire */
extern int        nframes;

int  main             ( int argc, char **argv );    /* main of Atari800 */
void RestoreSIO       ( void );
void SetSIOEsc        ( void );
void DisablePILL      ( void );
void Clear_Temp_Files ( void );
int  ReadAtariExe     ( char *filename );
BOOL dcmtoatr         ( FILE *fin, FILE *fout, char *input, char *output );

#ifdef __cplusplus
}
#endif

#endif /*__ATARI800_H__*/
