/* platform-independent drawing LED on screen */

#include "config.h"

#ifdef SET_LED

#include "diskled.h"

int LED_status = 0;
int LED_off_delay = 0;

#ifdef NO_LED_ON_SCREEN

#include "platform.h"

void Update_LED(void) {
	static int last_LED_status = 0;
	if (LED_status != last_LED_status)
		Atari_Set_LED(last_LED_status = LED_status);
	if (--LED_off_delay == 0)
		LED_status = 0;
}

#else /* NO_LED_ON_SCREEN */

#include "antic.h"	/* for atari_screen */

#ifndef WIN32
int LED_lastline = ATARI_HEIGHT - 1;

#define DISKLED_FONT_WIDTH		5
#define DISKLED_FONT_HEIGHT		7
#define DISKLED_FONT_CHARSIZE	(DISKLED_FONT_WIDTH * DISKLED_FONT_HEIGHT)
#endif

static unsigned char DiskLED[]= {
172,172,172,172,172,
172,172,000,172,172,
172,000,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,172,172,172,
	
172,172,172,172,172,
172,000,000,172,172,
172,172,172,000,172,
172,172,000,172,172,
172,000,172,172,172,
172,000,000,000,172,
172,172,172,172,172,
	
172,172,172,172,172,
172,000,000,172,172,
172,172,172,000,172,
172,172,000,172,172,
172,172,172,000,172,
172,000,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,172,000,172,
172,172,000,000,172,
172,000,172,000,172,
172,000,000,000,172,
172,172,172,000,172,
172,172,172,172,172,

172,172,172,172,172,
172,000,000,000,172,
172,000,172,172,172,
172,000,000,000,172,
172,172,172,000,172,
172,000,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,000,172,172,
172,000,172,172,172,
172,000,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,000,000,000,172,
172,172,172,000,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,		
172,172,000,172,172,
172,000,172,000,172,
172,000,172,000,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,	/* End of read LEDs	*/

053,053,053,053,053,	/* Start of write LEDs */
053,053,000,053,053,
053,000,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,053,053,
053,053,053,000,053,
053,053,000,053,053,
053,000,053,053,053,
053,000,000,000,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,053,053,
053,053,053,000,053,
053,053,000,053,053,
053,053,053,000,053,
053,000,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,053,000,053,
053,053,000,000,053,
053,000,053,000,053,
053,000,000,000,053,
053,053,053,000,053,
053,053,053,053,053,


053,053,053,053,053,
053,000,000,000,053,
053,000,053,053,053,
053,000,000,000,053,
053,053,053,000,053,
053,000,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,053,053,
053,000,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,000,053,
053,053,053,000,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,000,053,
053,000,053,000,053,
053,000,053,000,053,
053,053,000,053,053,	
053,053,053,053,053	/* End of write LEDs	*/
};

#ifndef WIN32
void Update_LED(void)
#else
void Update_LED(UBYTE *scrn)
#endif
{
	if (LED_status) {
		UBYTE *shape = DiskLED + (LED_status - 1) * DISKLED_FONT_CHARSIZE;
		int x,y;
#ifndef WIN32
		UBYTE *scrn = (UBYTE *)atari_screen
					  + (LED_lastline + 1 - DISKLED_FONT_HEIGHT) * ATARI_WIDTH
					  + 352 - DISKLED_FONT_WIDTH;
#else
		if(!scrn)
			scrn = (UBYTE *)atari_screen
				   + (ATARI_HEIGHT - DISKLED_FONT_HEIGHT) * ATARI_WIDTH
				   + 352 - DISKLED_FONT_WIDTH;
#endif

		for (y = 0; y < DISKLED_FONT_HEIGHT; y++) {
			for( x = 0; x < DISKLED_FONT_WIDTH; x++)
				*scrn++ = *shape++;
			scrn += ATARI_WIDTH - DISKLED_FONT_WIDTH;
		}
		if (--LED_off_delay == 0)
			LED_status = 0;
	}
}

#endif /* NO_LED_ON_SCREEN */

#endif /* SET_LED */
