/****************************************************************************
File    : SettingsDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CSettingsDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 08.10.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "SettingsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_SETTINGS_FIRST		IDC_SETTINGS_C000RAM
#define IDC_SETTINGS_LAST		IDC_SETTINGS_CANCEL


/////////////////////////////////////////////////////////////////////////////
// Static objects

static int s_anAvailableSpeed[] =
{
	50,  60,  70,  80,  90,  100, 110, 120,
	130, 140, 150, 160,	170, 180, 190, 200
};

static const int s_nAvailableSpeedNo = sizeof(s_anAvailableSpeed)/sizeof(s_anAvailableSpeed[0]);


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg dialog

BEGIN_MESSAGE_MAP(CSettingsDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingsDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SETTINGS_REFRESHSPIN, OnDeltaposRefreshSpin)
	ON_EN_KILLFOCUS(IDC_SETTINGS_REFRESHRATE, OnKillfocusRefreshRate)
	ON_BN_CLICKED(IDC_SETTINGS_FULLSPEED, OnFullSpeed)
	ON_BN_CLICKED(IDC_SETTINGS_C000RAM, OnC000Ram)
	ON_BN_CLICKED(IDC_SETTINGS_ENABLEROM, OnEnableRom)
	ON_BN_CLICKED(IDC_SETTINGS_ENABLESIO, OnEnableSio)
	ON_BN_CLICKED(IDC_SETTINGS_HOLDOPTION, OnHoldOption)
	ON_CBN_SELCHANGE(IDC_SETTINGS_SPEEDPERCENT, OnSelchangeSpeedPercent)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_SETTINGS_OK, OnOK)
	ON_BN_CLICKED(IDC_SETTINGS_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CSettingsDlg::CSettingsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CSettingsDlg::
CSettingsDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CSettingsDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CSettingsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CSettingsDlg::CSettingsDlg */

/*========================================================
Method   : CSettingsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CSettingsDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CSettingsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CSettingsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg implementation

/*========================================================
Method   : CSettingsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CSettingsDlg::
SetDlgState()
{
	char szItem[ 4 ];
	int  nSel = 5;

	CComboBox *pCombo  = (CComboBox *)GetDlgItem( IDC_SETTINGS_SPEEDPERCENT );
	CWnd      *pCbLab  = GetDlgItem( IDC_SETTINGS_SPEEDPERCENT_LABEL );
	CButton	  *pButton = NULL;

	/* Set up "Speed Percent" combo */
	ASSERT(pCombo && pCbLab);
	for( int i = 0; i < s_nAvailableSpeedNo; i++ )
	{
		sprintf( szItem, "%d", s_anAvailableSpeed[ i ] );
		pCombo->AddString( szItem );
		if( s_anAvailableSpeed[ i ] == m_nSpeedPercent )
			nSel = i;
	}
	if( CB_ERR == pCombo->SetCurSel( nSel ) )
		pCombo->SetCurSel( (5 == nSel ? 0 : 5) );
	pCombo->EnableWindow( !(m_ulMiscStates & MS_FULL_SPEED) );
	pCbLab->EnableWindow( !(m_ulMiscStates & MS_FULL_SPEED) );

	/* Set up check buttons states */
	if( m_ulMiscStates & MS_FULL_SPEED )
	{
		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_FULLSPEED );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}

	if( m_nEnableC000Ram )
	{
		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_C000RAM );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}

	pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLEROM );
	ASSERT(pButton);
	if( m_nEnableRomPatches )
	{
		pButton->SetCheck( 1 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
		ASSERT(pButton);
		pButton->EnableWindow( TRUE );

		if( m_nEnableSIOPatch )
			pButton->SetCheck( 1 );
	}
	else /* ROM patch == FALSE automatically disables SIO_PATCH */
	{
		pButton->SetCheck( 0 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
		pButton->EnableWindow( FALSE );
		m_nEnableSIOPatch = 0; /* turn off SIO patch */
	}

	if( m_nHoldOption )
	{
		pButton = (CButton*)GetDlgItem( IDC_SETTINGS_HOLDOPTION );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	SetDlgItemInt( IDC_SETTINGS_REFRESHRATE, m_nRefreshRate, FALSE );

} /* #OF# CSettingsDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg message handlers

/*========================================================
Method   : CSettingsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CSettingsDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_nEnableRomPatches = enable_rom_patches;
	m_nEnableSIOPatch   = enable_sio_patch;
	m_nEnableC000Ram    = enable_c000_ram;
	m_nHoldOption       = hold_option;
	m_nRefreshRate      = refresh_rate;
	m_ulMiscStates      = g_ulMiscStates;
	m_nSpeedPercent     = g_nSpeedPercent;

	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CSettingsDlg::OnInitDialog */

/*========================================================
Method   : CSettingsDlg::OnFullSpeed
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Full Speed check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnFullSpeed() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_FULLSPEED );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_FULL_SPEED;
	else
		m_ulMiscStates &= ~MS_FULL_SPEED;

	SetDlgState();
} /* #OF# CSettingsDlg::OnFullSpeed */

/*========================================================
Method   : CSettingsDlg::OnC000Ram
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Enable C000 RAM check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnC000Ram() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_C000RAM );
	ASSERT(pButton);
	m_nEnableC000Ram = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnC000Ram */

/*========================================================
Method   : CSettingsDlg::OnEnableRom
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Enable ROM Patches check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnEnableRom() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLEROM );
	ASSERT(pButton);
	m_nEnableRomPatches = pButton->GetCheck();

	SetDlgState();
} /* #OF# CSettingsDlg::OnEnableRom */

/*========================================================
Method   : CSettingsDlg::OnEnableSio
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Enable SIO Patch check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnEnableSio() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
	ASSERT(pButton);
	m_nEnableSIOPatch = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnEnableSio */

/*========================================================
Method   : CSettingsDlg::OnHoldOption
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Hold Option check box */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnHoldOption()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_HOLDOPTION );
	ASSERT(pButton);
	m_nHoldOption = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnHoldOption */

/*========================================================
Method   : CSettingsDlg::OnDeltaposRefreshSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Refresh Rate spin */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnDeltaposRefreshSpin( NMHDR   *pNMHDR, /* #IN#  */
					   LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nRefreshRate -= pNMUpDown->iDelta;
	if( m_nRefreshRate < 1 )
		m_nRefreshRate = 1;
	if( m_nRefreshRate > 99 )
		m_nRefreshRate = 99;

	SetDlgItemInt( IDC_SETTINGS_REFRESHRATE, m_nRefreshRate, FALSE );

	*pResult = 0;
} /* #OF# CSettingsDlg::OnDeltaposRefreshSpin */

/*========================================================
Method   : CSettingsDlg::OnKillfocusRefreshRate
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Refresh Rate edit */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnKillfocusRefreshRate()
{
	BOOL bTrans;
	int  nRefreshRate = GetDlgItemInt( IDC_SETTINGS_REFRESHRATE, &bTrans, FALSE );

	if( bTrans )
	{
		m_nRefreshRate = nRefreshRate;
		if( m_nRefreshRate < 1 )
			m_nRefreshRate = 1;
		if( m_nRefreshRate > 99 )
			m_nRefreshRate = 99;
	}
	if( !bTrans || nRefreshRate < 1 || nRefreshRate > 99 )
		SetDlgItemInt( IDC_SETTINGS_REFRESHRATE, m_nRefreshRate, FALSE );
} /* #OF# CSettingsDlg::OnKillfocusRefreshRate */

/*========================================================
Method   : CSettingsDlg::OnSelchangeSpeedPercent
=========================================================*/
/* #FN#
	Sets a state of the object regarding to changing Drive Number combo */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnSelchangeSpeedPercent()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_SETTINGS_SPEEDPERCENT );
	ASSERT(pCombo != NULL);
	m_nSpeedPercent = s_anAvailableSpeed[ pCombo->GetCurSel() ];
} /* #OF# CSettingsDlg::OnSelchangeSpeedPercent */

/*========================================================
Method   : CSettingsDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CSettingsDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	if( IDC_SETTINGS_REFRESHRATE == nCtrlID )
	{
		OnKillfocusRefreshRate();
	}
} /* #OF# CSoundDlg::ReceiveFocused */

/*========================================================
Method   : CSettingsDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnOK() 
{
	BOOL bReboot = FALSE;

	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_nHoldOption != hold_option )
	{
		hold_option = m_nHoldOption;
		WriteRegDWORD( NULL, REG_HOLD_OPTION, hold_option );
//		bReboot = TRUE; /* I think we don't really need this */
	}
	if( m_nEnableC000Ram != enable_c000_ram )
	{
		enable_c000_ram = m_nEnableC000Ram;
		WriteRegDWORD( NULL, REG_ENABLE_C000_RAM, enable_c000_ram );
		bReboot = TRUE;
	}
	if( m_nEnableRomPatches != enable_rom_patches )
	{
		enable_rom_patches = m_nEnableRomPatches;
		WriteRegDWORD( NULL, REG_ENABLE_ROM_PATCH, enable_rom_patches );
		bReboot = TRUE;
	}
	if( m_nEnableSIOPatch != enable_sio_patch )
	{
		enable_sio_patch = (m_nEnableSIOPatch && enable_rom_patches ? 1 : 0);
		if( enable_sio_patch )
			SetSIOEsc();
		else
			RestoreSIO();
		WriteRegDWORD( NULL, REG_ENABLE_SIO_PATCH, enable_sio_patch );
	}
	if( m_nRefreshRate != refresh_rate )
	{
		refresh_rate = m_nRefreshRate;
		WriteRegDWORD( NULL, REG_REFRESH_RATE, refresh_rate );

		if( !ST_DOUBLE_REFRESH )
			g_nTestVal = refresh_rate - 1;
	}

	if( m_ulMiscStates != g_ulMiscStates )
	{
		BOOL bFullSpeed = g_ulMiscStates & MS_FULL_SPEED;

		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );

		if( !bFullSpeed && g_ulMiscStates & MS_FULL_SPEED )
			ClearSound( FALSE );
		else
		if( bFullSpeed && !(g_ulMiscStates & MS_FULL_SPEED) )
			RestartSound();
	}

	if( m_nSpeedPercent != g_nSpeedPercent )
	{
		g_nSpeedPercent = m_nSpeedPercent;
		WriteRegDWORD( NULL, REG_SPEED_PERCENT, g_nSpeedPercent );

		g_nPalFreq  = (50 * m_nSpeedPercent) / 100;
		g_nNtscFreq = (60 * m_nSpeedPercent) / 100;

		/* The Atari timer stuff has to be reinitialised */
		ResetAtariTimer();

		/* Sound depends on the timer settings */
		ClearSound( TRUE );
		InitialiseSound();

		/* Start an Atari timer */
		StartAtariTimer();
	}
	/* If the Atari load failed, we just reset g_hViewWnd to NULL and the
	   Atari will be rebooted when the screen is refreshed in OnDraw */
	if( bReboot || g_ulAtariState & ATARI_UNINITIALIZED )
		RestartEmulation();

	CDialog::OnOK();
} /* #OF# CSettingsDlg::OnOK */

BOOL
CSettingsDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_SETTINGS,
				  IDC_SETTINGS_FIRST, IDC_SETTINGS_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
