/****************************************************************************
File    : PaletteAdvDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CPaletteAdvDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 14.10.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "PaletteAdvDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_PALETTEADV_FIRST	IDC_PALETTEADV_BLACKLEVEL
#define IDC_PALETTEADV_LAST		IDC_PALETTEADV_CANCEL

#define MAX_BLACK		255
#define MAX_WHITE		255
#define MAX_INTENSITY	255
#define MAX_SHIFT		255


/////////////////////////////////////////////////////////////////////////////
// CPaletteAdvDlg dialog

BEGIN_MESSAGE_MAP(CPaletteAdvDlg, CDialog)
	//{{AFX_MSG_MAP(CPaletteAdvDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_PALETTEADV_BLACKSPIN, OnDeltaposBlackSpin)
	ON_EN_KILLFOCUS(IDC_PALETTEADV_BLACKLEVEL, OnKillfocusBlackLevel)
	ON_NOTIFY(UDN_DELTAPOS, IDC_PALETTEADV_WHITESPIN, OnDeltaposWhiteSpin)
	ON_EN_KILLFOCUS(IDC_PALETTEADV_WHITELEVEL, OnKillfocusWhiteLevel)
	ON_NOTIFY(UDN_DELTAPOS, IDC_PALETTEADV_INTENSITYSPIN, OnDeltaposIntensitySpin)
	ON_EN_KILLFOCUS(IDC_PALETTEADV_COLORINTENSITY, OnKillfocusColorIntensity)
	ON_NOTIFY(UDN_DELTAPOS, IDC_PALETTEADV_SHIFTSPIN, OnDeltaposShiftSpin)
	ON_EN_KILLFOCUS(IDC_PALETTEADV_COLORSHIFT, OnKillfocusColorShift)
	ON_BN_CLICKED(IDC_PALETTEADV_TRANSLOADED, OnTransLoaded)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_PALETTEADV_OK, OnOK)
	ON_BN_CLICKED(IDC_PALETTEADV_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CPaletteAdvDlg::CPaletteAdvDlg
=========================================================*/
/* #FN#
   Standard constructor */
CPaletteAdvDlg::
CPaletteAdvDlg(
	ULONG *pMiscStates,
	int   *pBlackLevel,
	int   *pWhiteLevel,
	int   *pIntensity,
	int   *pShift,
	CWnd  *pParent /*=NULL*/ /* #IN# Pointer to parent window */
)
	: CDialog( CPaletteAdvDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CPaletteAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	ASSERT(pMiscStates && pBlackLevel && pWhiteLevel && pIntensity && pShift);

	m_pMiscStates = pMiscStates;
	m_pBlackLevel = pBlackLevel;
	m_pWhiteLevel = pWhiteLevel;
	m_pIntensity  = pIntensity;
	m_pShift      = pShift;
} /* #OF# CPaletteAdvDlg::CPaletteAdvDlg */

/*========================================================
Method   : CPaletteAdvDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CPaletteAdvDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CPaletteAdvDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CPaletteAdvDlg implementation

/*========================================================
Method   : CPaletteAdvDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
SetDlgState()
{
	/* Set up check buttons states */
	if( m_ulMiscStates & MS_TRANS_LOADED_PAL )
	{
		CButton *pButton = (CButton *)GetDlgItem( IDC_PALETTEADV_TRANSLOADED );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	SetDlgItemInt( IDC_PALETTEADV_BLACKLEVEL, m_nBlackLevel, FALSE );
	SetDlgItemInt( IDC_PALETTEADV_WHITELEVEL, m_nWhiteLevel, FALSE );
	SetDlgItemInt( IDC_PALETTEADV_COLORINTENSITY, m_nIntensity, FALSE );
	SetDlgItemInt( IDC_PALETTEADV_COLORSHIFT, m_nShift, FALSE );

} /* #OF# CPaletteAdvDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CPaletteAdvDlg message handlers

/*========================================================
Method   : CPaletteAdvDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CPaletteAdvDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_ulMiscStates = *m_pMiscStates;
	m_nBlackLevel  = *m_pBlackLevel;
	m_nWhiteLevel  = *m_pWhiteLevel;
	m_nIntensity   = *m_pIntensity;
	m_nShift       = *m_pShift;

	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CPaletteAdvDlg::OnInitDialog */

/*========================================================
Method   : CPaletteAdvDlg::OnTransLoaded
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Translate Loaded Palette check box */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnTransLoaded()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_PALETTEADV_TRANSLOADED );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_TRANS_LOADED_PAL;
	else
		m_ulMiscStates &= ~MS_TRANS_LOADED_PAL;
} /* #OF# CPaletteAdvDlg::OnTransLoaded */

/*========================================================
Method   : CPaletteAdvDlg::OnDeltaposBlackSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Black Level spin */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnDeltaposBlackSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nBlackLevel -= pNMUpDown->iDelta;
	if( m_nBlackLevel < 0 )
		m_nBlackLevel = 0;
	if( m_nBlackLevel > MAX_BLACK )
		m_nBlackLevel = MAX_BLACK;

	SetDlgItemInt( IDC_PALETTEADV_BLACKLEVEL, m_nBlackLevel, FALSE );

	*pResult = 0;
} /* #OF# CPaletteAdvDlg::OnDeltaposBlackSpin */

/*========================================================
Method   : CPaletteAdvDlg::OnKillfocusBlackLevel
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Black Level edit */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnKillfocusBlackLevel()
{
	BOOL bTrans;
	int  nBlackLevel = GetDlgItemInt( IDC_PALETTEADV_BLACKLEVEL, &bTrans, FALSE );

	if( bTrans )
	{
		m_nBlackLevel = nBlackLevel;
		if( m_nBlackLevel < 0 )
			m_nBlackLevel = 0;
		if( m_nBlackLevel > MAX_BLACK )
			m_nBlackLevel = MAX_BLACK;
	}
	if( !bTrans || nBlackLevel < 0 || nBlackLevel > MAX_BLACK )
		SetDlgItemInt( IDC_PALETTEADV_BLACKLEVEL, m_nBlackLevel, FALSE );
} /* #OF# CPaletteAdvDlg::OnKillfocusBlackLevel */

/*========================================================
Method   : CPaletteAdvDlg::OnDeltaposWhiteSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to White Level spin */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnDeltaposWhiteSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nWhiteLevel -= pNMUpDown->iDelta;
	if( m_nWhiteLevel < 0 )
		m_nWhiteLevel = 0;
	if( m_nWhiteLevel > MAX_WHITE )
		m_nWhiteLevel = MAX_WHITE;

	SetDlgItemInt( IDC_PALETTEADV_WHITELEVEL, m_nWhiteLevel, FALSE );

	*pResult = 0;
} /* #OF# CPaletteAdvDlg::OnDeltaposWhiteSpin */

/*========================================================
Method   : CPaletteAdvDlg::OnKillfocusWhiteLevel
=========================================================*/
/* #FN#
	Sets a state of the object regarding to White Level edit */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnKillfocusWhiteLevel()
{
	BOOL bTrans;
	int  nWhiteLevel = GetDlgItemInt( IDC_PALETTEADV_WHITELEVEL, &bTrans, FALSE );

	if( bTrans )
	{
		m_nWhiteLevel = nWhiteLevel;
		if( m_nWhiteLevel < 0 )
			m_nWhiteLevel = 0;
		if( m_nWhiteLevel > MAX_WHITE )
			m_nWhiteLevel = MAX_WHITE;
	}
	if( !bTrans || nWhiteLevel < 0 || nWhiteLevel > MAX_BLACK )
		SetDlgItemInt( IDC_PALETTEADV_WHITELEVEL, m_nWhiteLevel, FALSE );
} /* #OF# CPaletteAdvDlg::OnKillfocusWhiteLevel */

/*========================================================
Method   : CPaletteAdvDlg::OnDeltaposIntensitySpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Color Intensity spin */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnDeltaposIntensitySpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nIntensity -= pNMUpDown->iDelta;
	if( m_nIntensity < 0 )
		m_nIntensity = 0;
	if( m_nIntensity > MAX_INTENSITY )
		m_nIntensity = MAX_INTENSITY;

	SetDlgItemInt( IDC_PALETTEADV_COLORINTENSITY, m_nIntensity, FALSE );

	*pResult = 0;
} /* #OF# CPaletteAdvDlg::OnDeltaposIntensitySpin */

/*========================================================
Method   : CPaletteAdvDlg::OnKillfocusColorIntensity
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Color Intensity edit */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnKillfocusColorIntensity()
{
	BOOL bTrans;
	int  nIntensity = GetDlgItemInt( IDC_PALETTEADV_COLORINTENSITY, &bTrans, FALSE );

	if( bTrans )
	{
		m_nIntensity = nIntensity;
		if( m_nIntensity < 0 )
			m_nIntensity = 0;
		if( m_nIntensity > MAX_INTENSITY )
			m_nIntensity = MAX_INTENSITY;
	}
	if( !bTrans || nIntensity < 0 || nIntensity > MAX_INTENSITY )
		SetDlgItemInt( IDC_PALETTEADV_COLORINTENSITY, m_nIntensity, FALSE );
} /* #OF# CPaletteAdvDlg::OnKillfocusColorIntensity */

/*========================================================
Method   : CPaletteAdvDlg::OnDeltaposShiftSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Color Shift spin */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnDeltaposShiftSpin(
	NMHDR   *pNMHDR, /* #IN#  */
	LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nShift -= pNMUpDown->iDelta;
	if( m_nShift < 0 )
		m_nShift = 0;
	if( m_nShift > MAX_SHIFT )
		m_nShift = MAX_SHIFT;

	SetDlgItemInt( IDC_PALETTEADV_COLORSHIFT, m_nShift, FALSE );

	*pResult = 0;
} /* #OF# CPaletteAdvDlg::OnDeltaposShiftSpin */

/*========================================================
Method   : CPaletteAdvDlg::OnKillfocusColorShift
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Color Shift edit */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnKillfocusColorShift()
{
	BOOL bTrans;
	int  nShift = GetDlgItemInt( IDC_PALETTEADV_COLORSHIFT, &bTrans, FALSE );

	if( bTrans )
	{
		m_nShift = nShift;
		if( m_nShift < 0 )
			m_nShift = 0;
		if( m_nShift > MAX_SHIFT )
			m_nShift = MAX_SHIFT;
	}
	if( !bTrans || nShift < 0 || nShift > MAX_SHIFT )
		SetDlgItemInt( IDC_PALETTEADV_COLORSHIFT, m_nShift, FALSE );
} /* #OF# CPaletteAdvDlg::OnKillfocusColorShift */

/*========================================================
Method   : CPaletteAdvDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	switch( nCtrlID )
	{
		case IDC_PALETTEADV_BLACKLEVEL:
			OnKillfocusBlackLevel();
			break;
		case IDC_PALETTEADV_WHITELEVEL:
			OnKillfocusWhiteLevel();
			break;
		case IDC_PALETTEADV_COLORINTENSITY:
			OnKillfocusColorIntensity();
			break;
		case IDC_PALETTEADV_COLORSHIFT:
			OnKillfocusColorShift();
			break;
	}
} /* #OF# CPaletteAdvDlg::ReceiveFocused */

/*========================================================
Method   : CPaletteAdvDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CPaletteAdvDlg::
OnOK() 
{
	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_nBlackLevel != *m_pBlackLevel )
		*m_pBlackLevel = m_nBlackLevel;

	if( m_nWhiteLevel != *m_pWhiteLevel )
		*m_pWhiteLevel = m_nWhiteLevel;

	if( m_nIntensity != *m_pIntensity )
		*m_pIntensity = m_nIntensity;

	if( m_nShift != *m_pShift )
		*m_pShift = m_nShift;

	if( m_ulMiscStates != *m_pMiscStates )
		*m_pMiscStates = m_ulMiscStates;

	CDialog::OnOK();
} /* #OF# CPaletteAdvDlg::OnOK */

BOOL
CPaletteAdvDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_PALETTEADV,
				  IDC_PALETTEADV_FIRST, IDC_PALETTEADV_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
