/****************************************************************************
File    : MiscellanousDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CMiscellanousDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 09.12.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "MiscellanousDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_MISCELLANOUS_FIRST		IDC_MISCELLANOUS_MULTIPLEINSTANCE
#define IDC_MISCELLANOUS_LAST		IDC_MISCELLANOUS_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CMiscellanousDlg dialog

BEGIN_MESSAGE_MAP(CMiscellanousDlg, CDialog)
	//{{AFX_MSG_MAP(CMiscellanousDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_MISCELLANOUS_REFRESHSPIN, OnDeltaposRefreshSpin)
	ON_EN_KILLFOCUS(IDC_MISCELLANOUS_REFRESHRATE, OnKillfocusRefreshRate)
	ON_BN_CLICKED(IDC_MISCELLANOUS_MULTIPLEINSTANCE, OnMultipleInstance)
	ON_BN_CLICKED(IDC_MISCELLANOUS_CAPTURECTRLESC, OnCaptureCtrlEsc)
	ON_BN_CLICKED(IDC_MISCELLANOUS_REFRESHCHECK, OnRefreshCheck)
	ON_CBN_SELCHANGE(IDC_MISCELLANOUS_ARROWKEYS, OnSelchangeArrowKeys)
	ON_EN_KILLFOCUS(IDC_MISCELLANOUS_PRINTCMD, OnKillfocusPrintCmd)
	ON_BN_CLICKED(IDC_MISCELLANOUS_PRINTCHECK, OnPrintCheck)
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_MISCELLANOUS_DISPLAYLED, OnDisplayLED)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_MISCELLANOUS_OK, OnOK)
	ON_BN_CLICKED(IDC_MISCELLANOUS_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CMiscellanousDlg::CMiscellanousDlg
=========================================================*/
/* #FN#
   Standard constructor */
CMiscellanousDlg::
CMiscellanousDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CMiscellanousDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CMiscellanousDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CMiscellanousDlg::CMiscellanousDlg */

/*========================================================
Method   : CMiscellanousDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CMiscellanousDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CMiscellanousDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CMiscellanousDlg implementation

/*========================================================
Method   : CMiscellanousDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
SetDlgState()
{
	CComboBox *pCombo  = (CComboBox *)GetDlgItem( IDC_MISCELLANOUS_ARROWKEYS );
	CButton   *pButton = NULL;
	CWnd      *pWnd    = NULL;

	if( m_ulMiscStates & MS_MULTIPLE_INSTANCES )
	{
		pButton = (CButton*)GetDlgItem( IDC_MISCELLANOUS_MULTIPLEINSTANCE );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	if( m_ulMiscStates & MS_USE_DOUBLE_REFRESH )
	{
		pButton = (CButton*)GetDlgItem( IDC_MISCELLANOUS_REFRESHCHECK );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	if( m_ulMiscStates & MS_DISPLAY_DRIVE_LED )
	{
		pButton = (CButton*)GetDlgItem( IDC_MISCELLANOUS_DISPLAYLED );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	if( m_ulMiscStates & MS_USE_PRINT_COMMAND )
	{
		pButton = (CButton*)GetDlgItem( IDC_MISCELLANOUS_PRINTCHECK );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
	/* The Ctrl+Esc keystroke capturing may be turn off only in windowed
	   modes. This feature is always enable for full-screen modes */
	pButton = (CButton*)GetDlgItem( IDC_MISCELLANOUS_CAPTURECTRLESC );
	ASSERT(pButton);
	pButton->EnableWindow( !(g_ulScreenMode & SM_MODE_FULL) );

	if( m_ulMiscStates & MS_CAPTURE_CTRLESC || g_ulScreenMode & SM_MODE_FULL )
		pButton->SetCheck( 1 );

	/* Arrow keys mode */
	if( CB_ERR == pCombo->SetCurSel( m_nArrowsMode ) )
		pCombo->SetCurSel( 0 );

	/* Refresh rate for double-windowed mode */
	SetDlgItemInt( IDC_MISCELLANOUS_REFRESHRATE, m_nStretchedRate, FALSE );

	pWnd = GetDlgItem( IDC_MISCELLANOUS_REFRESHRATE );
	ASSERT(pWnd);
	pWnd->EnableWindow( m_ulMiscStates & MS_USE_DOUBLE_REFRESH );

	pWnd = GetDlgItem( IDC_MISCELLANOUS_REFRESHSPIN );
	ASSERT(pWnd);
	pWnd->EnableWindow( m_ulMiscStates & MS_USE_DOUBLE_REFRESH );

	/* An alternative print command */
	SetDlgItemText( IDC_MISCELLANOUS_PRINTCMD, m_szPrintCommand );

	pWnd = GetDlgItem( IDC_MISCELLANOUS_PRINTCMD );
	ASSERT(pWnd);
	pWnd->EnableWindow( m_ulMiscStates & MS_USE_PRINT_COMMAND );

} /* #OF# CMiscellanousDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CMiscellanousDlg message handlers

/*========================================================
Method   : CMiscellanousDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CMiscellanousDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_ulMiscStates   = g_ulMiscStates;
	m_nStretchedRate = g_nStretchedRate;
	m_nArrowsMode    = g_nArrowsMode;
	strncpy( m_szPrintCommand, print_command, 256 );

	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CMiscellanousDlg::OnInitDialog */

/*========================================================
Method   : CMiscellanousDlg::OnMultipleInstance
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Allow Multiple Instances check box */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
OnMultipleInstance()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MISCELLANOUS_MULTIPLEINSTANCE );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_MULTIPLE_INSTANCES;
	else
		m_ulMiscStates &= ~MS_MULTIPLE_INSTANCES;
} /* #OF# CMiscellanousDlg::OnMultipleInstance */

/*========================================================
Method   : CMiscellanousDlg::OnCaptureCtrlEsc
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Capture Ctrl+Esc check box */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
OnCaptureCtrlEsc()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MISCELLANOUS_CAPTURECTRLESC );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_CAPTURE_CTRLESC;
	else
		m_ulMiscStates &= ~MS_CAPTURE_CTRLESC;
} /* #OF# CMiscellanousDlg::OnCaptureCtrlEsc */

/*========================================================
Method   : CMiscellanousDlg::OnRefreshCheck
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Different Refresh Rate check box */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
OnRefreshCheck()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MISCELLANOUS_REFRESHCHECK );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_USE_DOUBLE_REFRESH;
	else
		m_ulMiscStates &= ~MS_USE_DOUBLE_REFRESH;

	SetDlgState();
} /* #OF# CMiscellanousDlg::OnRefreshCheck */

/*========================================================
Method   : CMiscellanousDlg::OnDeltaposRefreshSpin
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Refresh Rate spin */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
OnDeltaposRefreshSpin( NMHDR   *pNMHDR, /* #IN#  */
					   LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_nStretchedRate -= pNMUpDown->iDelta;
	if( m_nStretchedRate < 1 )
		m_nStretchedRate = 1;
	if( m_nStretchedRate > 99 )
		m_nStretchedRate = 99;

	SetDlgItemInt( IDC_MISCELLANOUS_REFRESHRATE, m_nStretchedRate, FALSE );

	*pResult = 0;
} /* #OF# CMiscellanousDlg::OnDeltaposRefreshSpin */

/*========================================================
Method   : CMiscellanousDlg::OnKillfocusRefreshRate
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Refresh Rate edit */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
OnKillfocusRefreshRate()
{
	BOOL bTrans;
	int  nStretchedRate = GetDlgItemInt( IDC_MISCELLANOUS_REFRESHRATE, &bTrans, FALSE );

	if( bTrans )
	{
		m_nStretchedRate = nStretchedRate;
		if( m_nStretchedRate < 1 )
			m_nStretchedRate = 1;
		if( m_nStretchedRate > 99 )
			m_nStretchedRate = 99;
	}
	if( !bTrans || nStretchedRate < 1 || nStretchedRate > 99 )
		SetDlgItemInt( IDC_MISCELLANOUS_REFRESHRATE, m_nStretchedRate, FALSE );
} /* #OF# CMiscellanousDlg::OnKillfocusRefreshRate */

void
CMiscellanousDlg::
OnSelchangeArrowKeys()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_MISCELLANOUS_ARROWKEYS );
	ASSERT(pCombo != NULL);
	m_nArrowsMode = pCombo->GetCurSel();
}

void
CMiscellanousDlg::
OnPrintCheck()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MISCELLANOUS_PRINTCHECK );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_USE_PRINT_COMMAND;
	else
		m_ulMiscStates &= ~MS_USE_PRINT_COMMAND;

	SetDlgState();
}

void
CMiscellanousDlg::
OnKillfocusPrintCmd()
{
	GetDlgItemText( IDC_MISCELLANOUS_PRINTCMD, m_szPrintCommand, 256 );
}

void
CMiscellanousDlg::
OnDisplayLED()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_MISCELLANOUS_DISPLAYLED );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_DISPLAY_DRIVE_LED;
	else
		m_ulMiscStates &= ~MS_DISPLAY_DRIVE_LED;
}

/*========================================================
Method   : CMiscellanousDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	switch( nCtrlID )
	{
		case IDC_MISCELLANOUS_REFRESHRATE:
			OnKillfocusRefreshRate();
			break;
		case IDC_MISCELLANOUS_PRINTCMD:
			OnKillfocusPrintCmd();
			break;
	}
} /* #OF# CMiscellanousDlg::ReceiveFocused */

/*========================================================
Method   : CMiscellanousDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CMiscellanousDlg::
OnOK()
{
	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	if( m_nStretchedRate != g_nStretchedRate )
	{
		g_nStretchedRate = m_nStretchedRate;
		WriteRegDWORD( NULL, REG_STRETCHED_RATE, g_nStretchedRate );

		if( ST_DOUBLE_REFRESH )
			g_nTestVal = g_nStretchedRate - 1;
	}
	if( m_nArrowsMode != g_nArrowsMode )
	{
		g_nArrowsMode = m_nArrowsMode;
		WriteRegDWORD( NULL, REG_ARROWS_MODE, g_nArrowsMode );

		SetArrowKeys( g_nArrowsMode );
	}
	if( m_ulMiscStates != g_ulMiscStates )
	{
		if( g_ulMiscStates & MS_CAPTURE_CTRLESC ^
			m_ulMiscStates & MS_CAPTURE_CTRLESC )
		{
			ToggleEscCapture();
		}
		/* This assigning isn't really needed */
		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );
	}
	if( *m_szPrintCommand == '\0' )
		strcpy( m_szPrintCommand, "Notepad %s" );
	if( _stricmp( m_szPrintCommand, print_command ) != 0 )
	{
		strncpy( print_command, m_szPrintCommand, 256 );
		WriteRegString( NULL, REG_PRINT_COMMAND, print_command );
	}
	CDialog::OnOK();
} /* #OF# CMiscellanousDlg::OnOK */

BOOL
CMiscellanousDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_MISCELLANOUS,
				  IDC_MISCELLANOUS_FIRST, IDC_MISCELLANOUS_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
