/****************************************************************************
File    : HarddiskDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CHarddiskDlg implementation file
@(#) #BY# Tomasz Szymankowski, Richard Lawrence
@(#) #LM# 17.10.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "FileSmallDlg.h"
#include "Helpers.h"
#include "HarddiskDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_HARDDISK_FIRST		IDC_HARDDISK_BUTTON1
#define IDC_HARDDISK_LAST		IDC_HARDDISK_CANCEL

#define HD_DRIVES_NO	4


/////////////////////////////////////////////////////////////////////////////
// Static objects

static CHarddiskDlg::DriveData_t s_aDriveData[ HD_DRIVES_NO ] =
{
	{ atari_h1_dir, ".", IDC_HARDDISK_EDIT1, REG_HD1 },
	{ atari_h2_dir, ".", IDC_HARDDISK_EDIT2, REG_HD2 },
	{ atari_h3_dir, ".", IDC_HARDDISK_EDIT3, REG_HD3 },
	{ atari_h4_dir, ".", IDC_HARDDISK_EDIT4, REG_HD4 }
};


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg dialog

BEGIN_MESSAGE_MAP(CHarddiskDlg, CDialog)
	//{{AFX_MSG_MAP(CHarddiskDlg)
	ON_BN_CLICKED(IDC_HARDDISK_BUTTON1, OnHd1)
	ON_BN_CLICKED(IDC_HARDDISK_BUTTON2, OnHd2)
	ON_BN_CLICKED(IDC_HARDDISK_BUTTON3, OnHd3)
	ON_BN_CLICKED(IDC_HARDDISK_BUTTON4, OnHd4)
	ON_EN_KILLFOCUS(IDC_HARDDISK_EDIT2, OnKillfocusHd2Edit)
	ON_EN_KILLFOCUS(IDC_HARDDISK_EDIT1, OnKillfocusHd1Edit)
	ON_EN_KILLFOCUS(IDC_HARDDISK_EDIT3, OnKillfocusHd3Edit)
	ON_EN_KILLFOCUS(IDC_HARDDISK_EDIT4, OnKillfocusHd4Edit)
	ON_BN_CLICKED(IDC_HARDDISK_READONLY, OnReadOnly)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_HARDDISK_OK, OnOK)
	ON_BN_CLICKED(IDC_HARDDISK_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

CHarddiskDlg::
CHarddiskDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CHarddiskDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CHarddiskDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_pDriveData = s_aDriveData;
}

void
CHarddiskDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CHarddiskDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg implementation

/*========================================================
Method   : CHarddiskDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CHarddiskDlg::
SetDlgState()
{
	CButton	*pButton = NULL;

	if( m_nHdReadOnly )
	{
		pButton = (CButton *)GetDlgItem( IDC_HARDDISK_READONLY );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
}


/////////////////////////////////////////////////////////////////////////////
// CHardDisk message handlers

BOOL
CHarddiskDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_nHdReadOnly = hd_read_only;

	/* Backup HD paths */
	for( int i = 0; i < HD_DRIVES_NO; i++ )
	{
		strncpy( m_pDriveData[ i ].szNewDir, m_pDriveData[ i ].pszDir, MAX_PATH );
		SetDlgItemText( m_pDriveData[ i ].nCtrlID, m_pDriveData[ i ].szNewDir );
	}
	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/*========================================================
Method   : CHarddiskDlg::OnReadOnly
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Read Only check box */
void
/* #AS#
   Nothing */
CHarddiskDlg::
OnReadOnly()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_HARDDISK_READONLY );
	ASSERT(pButton);
	m_nHdReadOnly = pButton->GetCheck();
} /* #OF# CHarddiskDlg::OnReadOnly */

void
CHarddiskDlg::
SetToDrive( int nDriveIndex )
{
	char   *pszDrivePath = m_pDriveData[ nDriveIndex ].szNewDir;
	CString	strPath = pszDrivePath;
	int	    nResult;

	CFileSmallDlg dlgFileSmall( TRUE, NULL, NULL, strPath, TRUE, this );
	if( IDOK == (nResult = dlgFileSmall.DoModal()) )
	{
		strPath = dlgFileSmall.GetPathName();
		if( strPath.IsEmpty() )
			strPath = ".";
		strcpy( pszDrivePath, strPath );
		if( pszDrivePath[ strlen( pszDrivePath ) - 1 ] == '\\' )
			pszDrivePath[ strlen( pszDrivePath ) - 1 ] = '\0';

		SetDlgItemText( m_pDriveData[ nDriveIndex ].nCtrlID, pszDrivePath );
	}
}

void
CHarddiskDlg::
OnHd1()
{
	SetToDrive( 0 );
}

void
CHarddiskDlg::
OnHd2()
{
	SetToDrive( 1 );
}

void
CHarddiskDlg::
OnHd3()
{
	SetToDrive( 2 );
}

void
CHarddiskDlg::
OnHd4()
{
	SetToDrive( 3 );
}

void
CHarddiskDlg::
KillfocusHdEdit( int nDriveIndex )
{
	GetDlgItemText( m_pDriveData[ nDriveIndex ].nCtrlID, m_pDriveData[ nDriveIndex ].szNewDir, MAX_PATH );
};

void
CHarddiskDlg::
OnKillfocusHd1Edit()
{
	KillfocusHdEdit( 0 );
}

void
CHarddiskDlg::
OnKillfocusHd2Edit()
{
	KillfocusHdEdit( 1 );
}

void
CHarddiskDlg::
OnKillfocusHd3Edit()
{
	KillfocusHdEdit( 2 );
}

void
CHarddiskDlg::
OnKillfocusHd4Edit()
{
	KillfocusHdEdit( 3 );
}

/*========================================================
Method   : CHarddiskDlg::ReceiveFocused
=========================================================*/
/* #FN#
   Receive the edit controls content again. The user could press
   'Enter' or 'Alt-O' and then all changes he's made in the last
   edited control would be lost. */
void
/* #AS#
   Nothing */
CHarddiskDlg::
ReceiveFocused()
{
	CWnd *pWnd    = GetFocus();
	UINT  nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;

	for( int i = 0; i < HD_DRIVES_NO; i++ )
	{
		/* Receive the edit contents again. The user could press 'Enter' or 'Alt-O'
		   and then all changes he's made in the last edited control would be lost */
		if( m_pDriveData[ i ].nCtrlID == nCtrlID )
		{
			KillfocusHdEdit( i );
			break;
		}
	}
} /* #OF# CHarddiskDlg::ReceiveFocused */

void
CHarddiskDlg::
OnOK()
{
	/* Unfortunately, edit controls do not lose the focus before
	   handling this when the user uses accelerators */
	ReceiveFocused();

	for( int i = 0; i < HD_DRIVES_NO; i++ )
	{
		if( m_pDriveData[ i ].szNewDir == '\0' )
			strcpy( m_pDriveData[ i ].szNewDir, "." );

		if( _stricmp( m_pDriveData[ i ].pszDir, m_pDriveData[ i ].szNewDir ) != 0 )
		{
			strcpy( m_pDriveData[ i ].pszDir, m_pDriveData[ i ].szNewDir );
			WriteRegString( NULL, m_pDriveData[ i ].pszRegName, m_pDriveData[ i ].pszDir );
		}
	}
	if( m_nHdReadOnly != hd_read_only )
	{
		hd_read_only = m_nHdReadOnly;
		WriteRegDWORD( NULL, REG_HD_READ_ONLY, hd_read_only );
	}
	CDialog::OnOK();
}

BOOL
CHarddiskDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_HARDDISK,
				  IDC_HARDDISK_FIRST, IDC_HARDDISK_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
