/****************************************************************************
File    : GraphicsDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CGraphicsDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 20.10.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "GraphicsAdvDlg.h"
#include "Helpers.h"
#include "GraphicsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_GRAPHICS_FIRST	IDC_GRAPHICS_320X200CLIP
#define IDC_GRAPHICS_LAST	IDC_GRAPHICS_CANCEL


/////////////////////////////////////////////////////////////////////////////
// Static objects

static CGraphicsDlg::GfxModeInfo_t s_aGfxModeInfo[] =
{
	{ IDC_GRAPHICS_320X200CLIP,     MODE_320_200,  SM_FRES_320_200,  IDI_NO_OVERSCAN,   "320x200",  "320x200x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_320X240PARTCLIP, MODE_320_240,  SM_FRES_320_240,  IDI_VERT_OVERSCAN, "320x240",  "320x240x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_400X300,         MODE_400_300,  SM_FRES_400_300,  IDI_FULL_OVERSCAN, "400x300",  "400x300x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_512X384,         MODE_512_384,  SM_FRES_512_384,  IDI_FULL_OVERSCAN, "512x384",  "512x384x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_640X400CLIP,     MODE_640_400,  SM_FRES_640_400,  IDI_NO_OVERSCAN,   "640x400",  "640x400x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_640X480PARTCLIP, MODE_640_480,  SM_FRES_640_480,  IDI_VERT_OVERSCAN, "640x480",  "640x480x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_800X600,         MODE_800_600,  SM_FRES_800_600,  IDI_FULL_OVERSCAN, "800x600",  "800x600x256 DDraw",  TRUE  },
	{ IDC_GRAPHICS_1024X768,        MODE_1024_768, SM_FRES_1024_768, IDI_FULL_OVERSCAN, "1024x768", "1024x768x256 DDraw", TRUE  },
	{ IDC_GRAPHICS_336X240WINDOWED, 0,             SM_WRES_NORMAL,   IDI_FULL_OVERSCAN, "normal",   "336x240 Windowed",   FALSE },
	{ IDC_GRAPHICS_672X480WINDOWED, 0,             SM_WRES_STRETCH,  IDI_FULL_OVERSCAN, "double",   "672x480 Windowed",   FALSE }
};

static const int s_nGfxModeInfoNo = sizeof(s_aGfxModeInfo)/sizeof(s_aGfxModeInfo[0]);


/////////////////////////////////////////////////////////////////////////////
// CGraphicsDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsDlg)
	ON_BN_CLICKED(IDC_GRAPHICS_320X200CLIP, OnMode320x200Clip)
	ON_BN_CLICKED(IDC_GRAPHICS_320X240PARTCLIP, OnMode320x240PartClip)
	ON_BN_CLICKED(IDC_GRAPHICS_400X300, OnMode400x300)
	ON_BN_CLICKED(IDC_GRAPHICS_512X384, OnMode512x384)
	ON_BN_CLICKED(IDC_GRAPHICS_640X400CLIP, OnMode640x400Clip)
	ON_BN_CLICKED(IDC_GRAPHICS_640X480PARTCLIP, OnMode640x480PartClip)
	ON_BN_CLICKED(IDC_GRAPHICS_800X600, OnMode800x600)
	ON_BN_CLICKED(IDC_GRAPHICS_1024X768, OnMode1024x768)
	ON_BN_CLICKED(IDC_GRAPHICS_336X240WINDOWED, On384x240Windowed)
	ON_BN_CLICKED(IDC_GRAPHICS_672X480WINDOWED, On768x480Windowed)
	ON_CBN_SELCHANGE(IDC_GRAPHICS_COMBO, OnSelchangeCombo)
	ON_BN_CLICKED(IDC_GRAPHICS_USEGDI, OnUseGDI)
	ON_BN_CLICKED(IDC_GRAPHICS_SHOWSCANLINES, OnShowScanlines)
	ON_BN_CLICKED(IDC_GRAPHICS_HIDECURSOR, OnHideCursor)
	ON_BN_CLICKED(IDC_GRAPHICS_ADVSETTING, OnAdvSetting)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_GRAPHICS_OK, OnOK)
	ON_BN_CLICKED(IDC_GRAPHICS_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CGraphicsDlg::CGraphicsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CGraphicsDlg::
CGraphicsDlg(
	CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */
)
	: CDialog( (g_ulScreenMode & SM_ATTR_SMALL_DLG ? IDD_GRAPHICS_SMALL : CGraphicsDlg::IDD), pParent )
{
	//{{AFX_DATA_INIT(CGraphicsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_pGfxModeInfo = s_aGfxModeInfo;
} /* #OF# CGraphicsDlg::CGraphicsDlg */

/*========================================================
Method   : CGraphicsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CGraphicsDlg::
DoDataExchange(
	CDataExchange *pDX /* #IN# Pointer to CDataExchange object */
)
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CGraphicsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg implementation

/*========================================================
Method   : CGraphicsDlg::SetButtonState
=========================================================*/
/* #FN#
   Sets pointed radio button state */
BOOL
/* #AS#
   TRUE if the mode is checked */
CGraphicsDlg::
SetButtonState(
	ULONG ulButtonID, /* #IN# Button resource ID */
	ULONG ulModeFlag, /* #IN# Sreen mode bit     */
	ULONG ulResFlag,  /* #IN# Resolution bit     */
	BOOL  bFullScreen /* #IN# Full screen flag   */
)
{
	CButton *pButton = (CButton *)GetDlgItem( ulButtonID );
	ASSERT(pButton);
	pButton->EnableWindow( (bFullScreen ? g_ulModesAvail & ulModeFlag : 1) != 0 );
	pButton->SetCheck( (m_ulScreenMode & ulResFlag && (bFullScreen ? m_ulScreenMode & SM_MODE_FULL : m_ulScreenMode & SM_MODE_WIND)) != 0 );

	return (BOOL)(m_ulScreenMode & ulResFlag);
} /* #OF# CGraphicsDlg::SetButtonState */

/*========================================================
Method   : CGraphicsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets dialog state */
void
/* #AS#
   Nothing */
CGraphicsDlg::
SetDlgState()
{
	CStatic   *pStatic = NULL;
	CButton   *pButton = NULL;
	HANDLE	   hIcon   = NULL;

	if( m_bSmallMode )
	{
		CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICS_COMBO );
		int nSelect = 0;
		int nIndex  = 0;
		ASSERT(pCombo);

		for( int i = 0; i < s_nGfxModeInfoNo; i++ )
		{
			if( (m_pGfxModeInfo[ i ].bFullScr ? g_ulModesAvail & m_pGfxModeInfo[ i ].dwMode : 1) )
			{
				nIndex = pCombo->AddString( m_pGfxModeInfo[ i ].pszItem );
				/* Remember internal id of the inserted item */
				pCombo->SetItemData( nIndex, (DWORD)i );
			}
			if( m_ulScreenMode & m_pGfxModeInfo[ i ].dwRes )
			{
				if( m_pGfxModeInfo[ i ].bFullScr )
				{
					if( m_ulScreenMode & SM_MODE_FULL )
					{
						hIcon = AfxGetApp()->LoadIcon( m_pGfxModeInfo[ i ].dwIconId );
						nSelect = nIndex;
					}
				}
				else
				{
					if( m_ulScreenMode & SM_MODE_WIND )
					{
						hIcon = AfxGetApp()->LoadIcon( m_pGfxModeInfo[ i ].dwIconId );
						nSelect = nIndex;
					}
				}
			}
		}
		pCombo->SetCurSel( nSelect );
	}
	else
	{
		for( int i = 0; i < s_nGfxModeInfoNo; i++ )
		{
			if( SetButtonState( m_pGfxModeInfo[ i ].dwCtrlId,
								m_pGfxModeInfo[ i ].dwMode,
								m_pGfxModeInfo[ i ].dwRes,
								m_pGfxModeInfo[ i ].bFullScr ) )
			{
				if( m_pGfxModeInfo[ i ].bFullScr )
				{
					pStatic = (CStatic *)GetDlgItem( IDC_GRAPHICS_FULLSCREEN );
					if( m_ulScreenMode & m_pGfxModeInfo[ i ].dwRes && m_ulScreenMode & SM_MODE_FULL )
						hIcon = AfxGetApp()->LoadIcon( m_pGfxModeInfo[ i ].dwIconId );
				}
				else
				{
					pStatic = (CStatic *)GetDlgItem( IDC_GRAPHICS_WINDOWED );
					if( m_ulScreenMode & m_pGfxModeInfo[ i ].dwRes && m_ulScreenMode & SM_MODE_WIND )
						hIcon = AfxGetApp()->LoadIcon( m_pGfxModeInfo[ i ].dwIconId );
				}
				ASSERT(pStatic);
				pStatic->SetWindowText( m_pGfxModeInfo[ i ].pszDesc );
			}
		}
	}
	pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_USEGDI );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_GDI) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_SHOWSCANLINES );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_SHOW_SCANLINES) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_HIDECURSOR );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_HIDE_CURSOR) != 0 );

	pStatic = (CStatic *)GetDlgItem( IDC_GRAPHICS_ICON );
	if( hIcon && pStatic )
		pStatic->SetIcon( (HICON)hIcon );
} /* #OF# CGraphicsDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsDlg message handlers

/*========================================================
Method   : CGraphicsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CGraphicsDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ulScreenMode = g_ulScreenMode;

	m_bSmallMode = g_ulScreenMode & SM_ATTR_SMALL_DLG;

	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CGraphicsDlg::OnInitDialog */

/*========================================================
Method   : CGraphicsDlg::OnMode320x200Clip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 320x200 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode320x200Clip() 
{
	int nResult = IDOK;
	/* There is a strange problem with messages routing during the dialog
	   navigation using keyboard. That's equally strange solving: */
	static BOOL bWarning = FALSE;
	if( bWarning )
		return;

	bWarning = TRUE;
	if( !(g_ulDontShowFlags & DONT_SHOW_MENU_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARN_NO_MENU, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_MENU_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
		m_ulScreenMode |= SM_FRES_320_200 | SM_MODE_FULL;
	}
	SetDlgState();

	bWarning = FALSE;
} /* #OF# CGraphicsDlg::OnMode320x200Clip */

/*========================================================
Method   : CGraphicsDlg::OnMode320x240Partclip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 320x240 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode320x240PartClip()
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_FRES_320_240 | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnMode320x240Partclip */

/*========================================================
Method   : CGraphicsDlg::OnMode400x300
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 400x300 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode400x300()
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_FRES_400_300 | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnMode400x300 */

/*========================================================
Method   : CGraphicsDlg::OnMode512x384
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 512x384 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode512x384()
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_FRES_512_384 | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnMode512x384 */

/*========================================================
Method   : CGraphicsDlg::OnMode640x400Clip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 640x400 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode640x400Clip()
{
	int nResult = IDOK;
	/* There is a strange problem with messages routing during the dialog
	   navigation using keyboard. That's strange solving: */
	static BOOL bWarning = FALSE;
	if( bWarning )
		return;

	bWarning = TRUE;
	if( !(g_ulDontShowFlags & DONT_SHOW_MENU_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARN_NO_MENU, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_MENU_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
		m_ulScreenMode |= SM_FRES_640_400 | SM_MODE_FULL;
	}
	SetDlgState();

	bWarning = FALSE;
} /* #OF# CGraphicsDlg::OnMode640x400Clip */

/*========================================================
Method   : CGraphicsDlg::OnMode640x480PartClip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 640x480 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode640x480PartClip()
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_FRES_640_480 | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnMode640x480PartClip */

/*========================================================
Method   : CGraphicsDlg::OnMode800x600
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 800x600 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode800x600()
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_FRES_800_600 | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnMode800x600 */

/*========================================================
Method   : CGraphicsDlg::OnMode1024x768
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 1024x768 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode1024x768()
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_FRES_1024_768 | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnMode1024x768 */

/*========================================================
Method   : CGraphicsDlg::On384x240Windowed
=========================================================*/
/* #FN#
   Sets DirectDraw windowed mode 384x240 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
On384x240Windowed() 
{
	m_ulScreenMode &= ~(SM_WRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_WRES_NORMAL | SM_MODE_WIND;

	SetDlgState();
} /* #OF# CGraphicsDlg::On384x240Windowed */

/*========================================================
Method   : CGraphicsDlg::On768x480Windowed
=========================================================*/
/* #FN#
   Sets DirectDraw windowed mode 768x480 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
On768x480Windowed() 
{
	int nResult = IDOK;
	/* There is a strange problem with messages routing during the dialog
	   navigation using keyboard. That's strange solving: */
	static BOOL bWarning = FALSE;
	if( bWarning )
		return;

	bWarning = TRUE;
	if( !(g_ulDontShowFlags & DONT_SHOW_GRAPHICS_WARN) )
	{
		CWarningDlg dlgWarning;
		char szMessage[ LOADSTRING_STRING_SIZE ];

		LoadString( NULL, IDS_WARN_DOUBLE_WND, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_GRAPHICS_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		m_ulScreenMode &= ~(SM_WRES_MASK | SM_MODE_MASK);
		m_ulScreenMode |= SM_WRES_STRETCH | SM_MODE_WIND;
	}
	SetDlgState();

	bWarning = FALSE;
} /* #OF# CGraphicsDlg::On768x480Windowed */

/*========================================================
Method   : CGraphicsDlg::OnSelchangeCombo
=========================================================*/
/* #FN#
   Sets graphics mode selected with Display Mode combo */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnSelchangeCombo()
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICS_COMBO );
	ASSERT(pCombo);

	switch( pCombo->GetItemData( pCombo->GetCurSel() ) )
	{
		case 0:
			OnMode320x200Clip();
			break;
		case 1:
			OnMode320x240PartClip();
			break;
		case 2:
			OnMode400x300();
			break;
		case 3:
			OnMode512x384();
			break;
		case 4:
			OnMode640x400Clip();
			break;
		case 5:
			OnMode640x480PartClip();
			break;
		case 6:
			OnMode800x600();
			break;
		case 7:
			OnMode1024x768();
			break;
		case 8:
			On384x240Windowed();
			break;
		case 9:
			On768x480Windowed();
			break;

		default:
			OnMode640x480PartClip();
			break;
	}
} /* #OF# CGraphicsDlg::OnSelchangeCombo */

/*========================================================
Method   : CGraphicsDlg::OnUseGDI
=========================================================*/
/* #FN#
   Turns on/off DirectDraw windowed mode */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnUseGDI()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_USEGDI );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_USE_GDI;
	else
		m_ulScreenMode &= ~SM_OPTN_USE_GDI;
} /* #OF# CGraphicsDlg::OnUseGDI */

/*========================================================
Method   : CGraphicsDlg::OnShowScanlines
=========================================================*/
/* #FN#
   Turns on/off scan lines */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnShowScanlines() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_SHOWSCANLINES );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_SHOW_SCANLINES;
	else
		m_ulScreenMode &= ~SM_OPTN_SHOW_SCANLINES;
} /* #OF# CGraphicsDlg::OnShowScanlines */

/*========================================================
Method   : CGraphicsDlg::OnHideCursor
=========================================================*/
/* #FN#
   Turns on/off the Hide Mouse Cursor flag */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnHideCursor()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_HIDECURSOR );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_HIDE_CURSOR;
	else
		m_ulScreenMode &= ~SM_OPTN_HIDE_CURSOR;
} /* #OF# CGraphicsDlg::OnHideCursor */

/*========================================================
Method   : CGraphicsDlg::OnAdvSetting
=========================================================*/
/* #FN#
   Displays "Advanced Graphics Options" dialog box */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnAdvSetting()
{
	CGraphicsAdvDlg dlgGraphicsAdv( &m_ulScreenMode, this );

	dlgGraphicsAdv.DoModal();
} /* #OF# CGraphicsDlg::OnAdvSetting */

/*========================================================
Method   : CGraphicsDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnOK() 
{
	if( m_ulScreenMode != g_ulScreenMode )
	{
		ULONG ulSavedMode = g_ulScreenMode;

		g_ulScreenMode = m_ulScreenMode;

		if( !InitialiseScreen( FALSE ) )
		{
			g_ulScreenMode = ulSavedMode;
			InitialiseScreen( FALSE );
		}
		WriteRegDWORD( NULL, REG_DDRAW_MODE, g_ulScreenMode );
	}
	CDialog::OnOK();
} /* #OF# CGraphicsDlg::OnOK */

BOOL
CGraphicsDlg::
OnHelpInfo(
	HELPINFO *pHelpInfo
)
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_GRAPHICS,
				  IDC_GRAPHICS_FIRST, IDC_GRAPHICS_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
