/****************************************************************************
File    : globals.c
/*
@(#) #SY# Atari800Win
@(#) #IS# Shared C-core attributes definitions
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 14.10.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "WinConfig.h"
#include <stdio.h>
#include "sio.h"
#include "registry.h"
#include "globals.h"


LPCSTR DEFAULT_A8K          = "keyboard.a8k";
LPCSTR DEFAULT_A8S          = "atarisav.a8s";
LPCSTR DEFAULT_OSA          = "\\atariosa.rom";
LPCSTR DEFAULT_OSB          = "\\atariosb.rom";
LPCSTR DEFAULT_OXL          = "\\atarixl.rom";
LPCSTR DEFAULT_O52          = "\\5200.rom";
LPCSTR DEFAULT_BAS          = "\\ataribas.rom";

HWND   g_hMainWnd           = NULL;
HWND   g_hViewWnd           = NULL;
int    g_nTestVal           = 0;
long   g_nSleepThreshold    = 0;
int    g_nMouseButtons      = 0;
int    g_nMouseX            = 0;
int    g_nMouseY            = 0;
int    g_nStartX            = DEF_START_X;
int    g_nStartY            = DEF_START_Y;
int    g_nAutofireMode      = DEF_AUTOFIRE_MODE;
int    g_nSoundRate         = DEF_SOUND_RATE;
int    g_nSoundVol          = DEF_SOUND_VOL;
int    g_nSkipUpdate        = DEF_SKIP_UPDATE;
int    g_nUseVolumeOnly     = DEF_USE_VOLUME_ONLY;
int    g_nShowCursor        = DEF_SHOW_CURSOR;
int    g_nMouseMode         = DEF_MOUSE_MODE;
int    g_nPenOffsetX        = DEF_PEN_OFFSET_X;
int    g_nPenOffsetY        = DEF_PEN_OFFSET_Y;
int    g_nMousePort         = DEF_MOUSE_PORT;
int    g_nMouseSpeed        = DEF_MOUSE_SPEED;
int    g_nPaddleRange       = DEF_PADDLE_RANGE;
int    g_nJoystickInertia   = DEF_JOYSTICK_INERTIA;
int    g_nStretchedRate     = DEF_STRETCHED_RATE;
int    g_nArrowsMode        = DEF_ARROWS_MODE;
int    g_nSpeedPercent      = DEF_SPEED_PERCENT;
int    g_nClrBlackLevel     = DEF_CLR_BLACK_LEVEL;
int    g_nClrWhiteLevel     = DEF_CLR_WHITE_LEVEL;
int    g_nClrIntensity      = DEF_CLR_INTENSITY;
int    g_nClrShift          = DEF_CLR_SHIFT;

RECT   g_rcViewBounds       = { 0, 0 };

ULONG  g_ulAtariState       = ATARI_UNINITIALIZED;
ULONG  g_ulModesAvail       = 0L;
ULONG  g_ulAtariHWNextTime  = 0L;
ULONG  g_ulDeltaT           = 0L;
ULONG  g_ulScreenMode       = DEF_SCREEN_MODE;
ULONG  g_ulMiscStates       = DEF_MISC_STATES;
ULONG  g_ulDontShowFlags    = DEF_DONT_SHOW_FLAGS;
ULONG  g_ulJoystickSelects  = DEF_JOYSTICK_SELECTS;
ULONG  g_ulSoundState       = DEF_SOUND_STATE;
ULONG  g_ulFileAssociations = DEF_FILE_ASSOCIATIONS;
ULONG  g_ulAutofireSticks   = DEF_AUTOFIRE_STICKS;

LPBITMAPINFO g_lpbmi        = NULL;	/* Bitmap info for our screen bitmap */

int   g_argc                = 0;
char *g_argv          [ 32 ];
char  g_szCmdLine     [ 2048 ];

char *g_apszDriveRegID[ MAX_DRIVES ] =
{
	REG_DRIVE1,
	REG_DRIVE2,
	REG_DRIVE3,
	REG_DRIVE4,
	REG_DRIVE5,
	REG_DRIVE6,
	REG_DRIVE7,
	REG_DRIVE8
};

char  g_szCurrentRom  [ MAX_PATH ];
char  g_szOtherRom    [ MAX_PATH ];
char  g_szTemplateFile[ MAX_PATH ];
char  g_szTemplateDesc[ MAX_PATH ];
char  g_szPaletteFile [ MAX_PATH ];
int   g_nKBTable      [ 256 ];		/* Number of virtual key codes */

PALETTEENTRY g_pe     [ 256 ];
