/****************************************************************************
File    : Atari800WinView.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CAtari800WinView implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 22.09.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Atari800WinDoc.h"
#include "MainFrame.h"
#include "Helpers.h"
#include "RomImagesDlg.h"
#include "Atari800WinView.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView

IMPLEMENT_DYNCREATE(CAtari800WinView, CView)

BEGIN_MESSAGE_MAP(CAtari800WinView, CView)
	//{{AFX_MSG_MAP(CAtari800WinView)
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
END_MESSAGE_MAP()

/*========================================================
Method   : CAtari800WinView::CAtari800WinView
=========================================================*/
/* #FN#
   Standard constructor */
CAtari800WinView::
CAtari800WinView()
{
	m_bMenuVisible = FALSE;
	m_bClearScreen = TRUE;

	m_pMainWnd = NULL;
} /* #OF# CAtari800WinView::CAtari800WinView */

/*========================================================
Method   : CAtari800WinView::~CAtari800WinView
=========================================================*/
/* #FN#
   Destructor */
CAtari800WinView::
~CAtari800WinView()
{
} /* #OF# CAtari800WinView::~CAtari800WinView */


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView implementation

/*========================================================
Method   : CAtari800WinView::StartAtariMachine
=========================================================*/
/* #FN#
   (Re)initializes an emulated Atari; invoked from OnDraw when
   g_hViewWnd is NULL */
void
/* #AS#
   Nothing */
CAtari800WinView::
StartAtariMachine()
{
	g_hViewWnd  = GetSafeHwnd();
	g_hScreenDC = ::GetDC( g_hViewWnd );
	
	/* Cache boundaries of the view window */
	RefreshViewBounds( TRUE );

	if( InitialiseScreen( FALSE ) &&
		InitialiseSound() &&
		InitialiseInput() )
	{
		g_ulAtariState = ATARI_RUNNING;
		/* Right before we actually start the Atari, we write out a boot
		   failure message to the registry. During _normal_ closing of
		   windows we clear the "failure" mark in the WM_CLOSE handler.
		   This way if the Atari causes the Windows program to crash it's
		   easy to tell by testing for boot failure upon reading the
		   value from the registry initially*/
		g_ulMiscStates |= MS_LAST_BOOT_FAILED;

		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );
	}
	else
	{
		g_ulAtariState = ATARI_UNINITIALIZED;
		Invalidate();
	}
	m_bMenuVisible = FALSE;

	DescribeAtariSystem();
} /* #OF# CAtari800WinView::StartAtariMachine */

/*========================================================
Method   : CAtari800WinView::OnEraseBkgnd
=========================================================*/
/* #FN#
   The framework calls this member function when the CWnd object
   background needs erasing (for example, when resized) */
BOOL
/* #AS#
   Nonzero if it erases the background; otherwise 0 */
CAtari800WinView::
OnEraseBkgnd(
	CDC *pDC /* #IN# Specifies the device-context object */
)
{
	/* Don't need to erase... We always have something that covers
	   the whole window */
	return TRUE;
} /* #OF# CAtari800WinView::OnEraseBkgnd */


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView drawing

/*========================================================
Method   : CAtari800WinView::OnDraw
=========================================================*/
/* #FN#
   Called by the framework to render an image of the document */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnDraw(
	CDC *pDC /* #IN# Points to the device context to be used for rendering an image of the document */
)
{
	if( g_ulAtariState & (ATARI_UNINITIALIZED | ATARI_CRASHED) )
	{
		RECT rc;
		if( g_ulAtariState & ATARI_LOAD_WARNING )
		{
			g_ulAtariState &= ~ATARI_LOAD_WARNING;
			/* Get surface for GDI if necessary */
			FlipToGDI();
			if( ST_MENUBAR_HIDDEN )
				ShowMenuBar( TRUE );

			if( IDYES == DisplayMessage( NULL, IDS_ERROR_BOOT, 0, MB_ICONWARNING | MB_YESNO ) )
			{
				CRomImagesDlg dlgRomImages;
				dlgRomImages.DoModal();
			}
		}
		else
		if( !m_bMenuVisible && g_ulAtariState & ATARI_UNINITIALIZED &&
			ST_MENUBAR_HIDDEN )
		{
			m_bMenuVisible = TRUE;
			ShowMenuBar( TRUE );
		}
		GetClientRect( &rc );
		pDC->PatBlt( rc.left, rc.top, rc.right, rc.bottom, BLACKNESS );

		DescribeAtariSystem( TRUE, 0 ); /* Force the status bar redrawing, speed 0 */
	}
	else
	if( !(g_ulAtariState & ATARI_CLOSING) )
	{
		if( !g_hViewWnd )
		{
			StartAtariMachine(); /* Restart the emulation */
		}
		else
		if( g_ulAtariState & (ATARI_PAUSED | ATARI_NOFOCUS) )
		{
			if( atari_screen && g_ulScreenMode & SM_MODE_WIND )
				/* Redraw the screen using GDI or DirectDraw */
				RedrawScreen( pDC->m_hDC );
			else
			/* m_bClearScreen is changed by CMainFrame menu looping handlers */
			if( m_bClearScreen )
			{
				RECT rc;
				GetClientRect( &rc );
				pDC->PatBlt( rc.left, rc.top, rc.right, rc.bottom, BLACKNESS );
			}
		}
	}
} /* #OF# CAtari800WinView::OnDraw */


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView diagnostics

#ifdef _DEBUG
void
CAtari800WinView::
AssertValid() const
{
	CView::AssertValid();
}

void
CAtari800WinView::
Dump( CDumpContext& dc ) const
{
	CView::Dump( dc );
}

CAtari800WinDoc*
CAtari800WinView::
GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAtari800WinDoc)));
	return (CAtari800WinDoc*)m_pDocument;
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView message handlers

/*========================================================
Method   : CAtari800WinView::OnKillFocus
=========================================================*/
/* #FN#
   The framework calls this member function immediately before
   losing the input focus */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnKillFocus(
	CWnd *pNewWnd /* #IN# Specifies a pointer to the window that receives the input focus */
)
{
	if( g_ulMiscStates & MS_MOUSE_CAPTURED )
		ShowMousePointer( TRUE );

	if( g_ulAtariState & ATARI_RUNNING )
	{
		g_ulAtariState |= ATARI_NOFOCUS;
		ClearSound( FALSE );
		ResetKeys();
		DescribeAtariSystem();
	}
	CView::OnKillFocus( pNewWnd );
} /* #OF# CAtari800WinView::OnKillFocus */

/*========================================================
Method   : CAtari800WinView::OnSetFocus
=========================================================*/
/* #FN#
   The framework calls this member function after gaining the input focus */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnSetFocus(
	CWnd *pOldWnd /* #IN# Contains the CWnd object that loses the input focus */
)
{
	LARGE_INTEGER lnTime;
	ULONG	      ulTimerLastVal = g_ulAtariHWNextTime;

	if( g_ulAtariState & (ATARI_UNINITIALIZED | ATARI_CRASHED) )
		return;

	/* Force screen refreshing */
	g_nTestVal = (ST_DOUBLE_REFRESH ? g_nStretchedRate : refresh_rate) - 1;

	g_ulAtariState &= ~ATARI_NOFOCUS;
	RestartSound();

	QueryPerformanceCounter( &lnTime );
	g_ulAtariHWNextTime = lnTime.LowPart + g_ulDeltaT;
	g_bTimerRollover    = (BOOL)(ulTimerLastVal > g_ulAtariHWNextTime);

	DescribeAtariSystem();

	CView::OnSetFocus( pOldWnd );
} /* #OF# CAtari800WinView::OnSetFocus */

/*========================================================
Method   : CAtari800WinView::OnDestroy
=========================================================*/
/* #FN#
   The framework calls this member function to inform the CWnd
   object that it is being destroyed */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnDestroy()
{
	g_ulAtariState = ATARI_UNINITIALIZED | ATARI_CLOSING;

	/* Clear last boot failed message so on reboot we don't think we crashed */
	g_ulMiscStates &= ~MS_LAST_BOOT_FAILED;
	WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );

	if( g_ulMiscStates & MS_MOUSE_CAPTURED )
		ClipCursor( NULL );

	if( g_ulMiscStates & MS_CAPTURE_CTRLESC )
		/* Enables task switching */
		EnableEscCapture( FALSE );

	Atari_Exit( 0 );

	if( g_hScreenDC && g_hViewWnd )
		::ReleaseDC( g_hViewWnd, g_hScreenDC );
	g_hScreenDC = NULL;
	g_hViewWnd  = NULL;

	CView::OnDestroy();
} /* #OF# CAtari800WinView::OnDestroy */

/*========================================================
Method   : CAtari800WinView::OnPrint
=========================================================*/
/* #FN#
   Called by the framework to print or preview a page of the document */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnPrint(
	CDC        *pDC,  /* #IN# Points to the printer device context */
	CPrintInfo *pInfo /* #IN# Points to structure that describes the current print job */
)
{
	int xRes, nMult;
	/* Make backup of original values */
	int nWidth  = g_lpbmi->bmiHeader.biWidth;
	int nHeight = g_lpbmi->bmiHeader.biHeight;

	g_lpbmi->bmiHeader.biWidth  =  ATARI_WIDTH;
	g_lpbmi->bmiHeader.biHeight = -ATARI_HEIGHT;

	/* Find the largest integral multiple of width on the page */
	xRes  = pDC->GetDeviceCaps( HORZRES );
	nMult = xRes / ATARI_WIDTH;
	/* And stretch the original DIB to that size */
	StretchDIBits( pDC->m_hDC, 0, 0, ATARI_WIDTH * nMult, ATARI_HEIGHT * nMult,
				   0, 0, ATARI_WIDTH, ATARI_HEIGHT,
				   atari_screen, g_lpbmi, DIB_RGB_COLORS, SRCCOPY );

	/* Restore original values */
	g_lpbmi->bmiHeader.biWidth  = nWidth;
	g_lpbmi->bmiHeader.biHeight = nHeight;

	CleanScreen( FALSE );
//	CView::OnPrint( pDC, pInfo );
} /* #OF# CAtari800WinView::OnPrint */

/*========================================================
Method   : CAtari800WinView::OnPreparePrinting
=========================================================*/
/* #FN#
   Called by the framework before a document is printed or previewed */
BOOL
/* #AS#
   Nothing */
CAtari800WinView::
OnPreparePrinting(
	CPrintInfo *pInfo /* #IN# Points to structure that describes the current print job */
)
{
	BOOL bResult = DoPreparePrinting( pInfo );
	CleanScreen();

	return bResult;
} /* #OF# CAtari800WinView::OnPreparePrinting */

/*========================================================
Method   : CAtari800WinView::OnInitialUpdate
=========================================================*/
/* #FN#
   Called by the framework after the view is first attached to the
   document, but before the view is initially displayed */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnInitialUpdate()
{
	CView::OnInitialUpdate();

	AfxGetMainWnd()->SetWindowPos( &wndNoTopMost, 0, 0, 
		ATARI_VIS_WIDTH +
			GetSystemMetrics( SM_CXDLGFRAME ) * 2 +
			GetSystemMetrics( SM_CXEDGE ) * 2,
		ATARI_HEIGHT + g_nStatusSize +
			GetSystemMetrics( SM_CYCAPTION ) +
			GetSystemMetrics( SM_CYMENU ) +
			GetSystemMetrics( SM_CYDLGFRAME ) * 2 +
			GetSystemMetrics( SM_CYEDGE ) * 2,
		SWP_NOMOVE | SWP_SHOWWINDOW | SWP_NOSENDCHANGING );

	m_pMainWnd = (CMainFrame*)AfxGetMainWnd();
	ASSERT(m_pMainWnd);
	m_pMainWnd->SetMainView( this );
} /* #OF# CAtari800WinView::OnInitialUpdate */

/*========================================================
Method   : CAtari800WinView::OnMouseMove
=========================================================*/
/* #FN#
   The framework calls this member function when the mouse cursor moves */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnMouseMove(
	UINT nFlags, /* #IN# Indicates whether various virtual keys are down */
	CPoint point /* #IN# Specifies the x- and y-coordinate of the cursor */
)
{
	if( !(g_ulMiscStates & MS_MOUSE_CAPTURED) )
		ShowMousePointer( TRUE );

	CView::OnMouseMove( nFlags, point );
} /* #OF# CAtari800WinView::OnMouseMove */

/*========================================================
Method   : CAtari800WinView::OnLButtonDown
=========================================================*/
/* #FN#
   The framework calls this member function when the user presses the left mouse button */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnLButtonDown(
	UINT nFlags, /* #IN# Indicates whether various virtual keys are down */
	CPoint point /* #IN# Specifies the x- and y-coordinate of the cursor */
)
{
	if( g_ulMiscStates & MS_MOUSE_CAPTURED )
		g_nMouseButtons |= 1;

	CView::OnLButtonDown( nFlags, point );
} /* #OF# CAtari800WinView::OnLButtonDown */

/*========================================================
Method   : CAtari800WinView::OnLButtonUp
=========================================================*/
/* #FN#
   The framework calls this member function when the user releases the left mouse button */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnLButtonUp(
	UINT nFlags, /* #IN# Indicates whether various virtual keys are down */
	CPoint point /* #IN# Specifies the x- and y-coordinate of the cursor */
)
{
	if( g_ulMiscStates & MS_MOUSE_CAPTURED )
		g_nMouseButtons &= ~1;
	
	CView::OnLButtonUp( nFlags, point );
} /* #OF# CAtari800WinView::OnLButtonUp */

/*========================================================
Method   : CAtari800WinView::OnRButtonDown
=========================================================*/
/* #FN#
   The framework calls this member function when the user presses the right mouse button */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnRButtonDown(
	UINT nFlags, /* #IN# Indicates whether various virtual keys are down */
	CPoint point /* #IN# Specifies the x- and y-coordinate of the cursor */
)
{
	if( g_ulMiscStates & MS_MOUSE_CAPTURED )
		g_nMouseButtons |= 2;
	
	CView::OnRButtonDown( nFlags, point );
} /* #OF# CAtari800WinView::OnRButtonDown */

/*========================================================
Method   : CAtari800WinView::OnRButtonUp
=========================================================*/
/* #FN#
   The framework calls this member function when the user releases the right mouse button */
void
/* #AS#
   Nothing */
CAtari800WinView::
OnRButtonUp(
	UINT nFlags, /* #IN# Indicates whether various virtual keys are down */
	CPoint point /* #IN# Specifies the x- and y-coordinate of the cursor */
)
{
	if( g_ulMiscStates & MS_MOUSE_CAPTURED )
		g_nMouseButtons &= ~2;
	
	CView::OnRButtonUp( nFlags, point );
} /* #OF# CAtari800WinView::OnRButtonUp */
