/****************************************************************************
File    : display_win.h
/*
@(#) #SY# Atari800Win
@(#) #IS# DisplayWin public methods and objects prototypes
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 01.10.2000
*/

#ifndef __DISPLAY_WIN_H__
#define __DISPLAY_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define BLIT_EFFECTS_NO		3

/* Exported methods */

int  InitialiseScreen   ( BOOL bForceInit );
void ClearScreen        ( BOOL bPermanent );
void CheckDDrawModes    ( void );
void ComputeClipArea    ( void );
void DrawPausedScreen   ( UBYTE *pScreen );
int  SetSafeDisplay     ( BOOL bForceGDI );
void FlipToGDI          ( void );
int  ToggleWindowedModes( void );
int  ToggleModes        ( void );
void RedrawScreen       ( HDC hDC );
int  SetupScreenPalette ( void );
void ShowMenuBar        ( BOOL bForceShow );

/* Exported globals */

extern void (*Atari_DisplayScreen)(UBYTE *screen);

extern HDC    g_hScreenDC;
extern int    g_nStatusSize;
extern UCHAR *g_screenbuff;

#ifdef __cplusplus
}
#endif

#endif /*__DISPLAY_WIN_H__*/
