/****************************************************************************
File    : misc_win.h
/*
@(#) #SY# Atari800Win
@(#) #IS# MiscWin public methods and objects prototypes
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 17.10.2000
*/

#ifndef __MISC_WIN_H__
#define __MISC_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define IAF_BIN_IMAGE	0x01
#define IAF_DSK_IMAGE	0x02
#define IAF_CRT_IMAGE	0x04
#define IAF_ROM_IMAGE	0x08
#define IAF_A8S_IMAGE	0x10
#define IAF_ATARI_FILE	0xff

/* Exported types */

enum RomType { RTI_OSA = 0, RTI_OSB, RTI_XLE, RTI_A52, RTI_BAS };

struct RomTypeInfo_t
{
	enum   RomType rtType;
	ULONG  ulCRC;
	LPCSTR pszDesc;		/* The pointer to a static text */
};

/* Exported methods */

BOOL   TestRomPaths       ( LPSTR pszStartPath, HWND hWnd );
void   ToggleFullSpeed    ( void );
void   TogglePause        ( void );
void   ToggleSIOPatch     ( void );
void   ToggleEscCapture   ( void );
void   EnableEscCapture   ( BOOL bEnable );
void   UseAtariPalette    ( void );
int    LaunchMonitor      ( void );
int    zlib_capable       ( void );
void   StartAtariTimer    ( void );
void   ResetAtariTimer    ( void );
void   ShowMousePointer   ( BOOL bShow );
int    Atari_Exit         ( int nPanic );
int	   FindCartType       ( LPCSTR pszFileName, BOOL bAutoDetect, BOOL bCheckExt );
BOOL   IsAtariFile        ( LPCSTR pszFileName, UINT *pFileType );
BOOL   IsCompressedFile   ( LPCSTR pszFileName );
BOOL   RunAtariExe        ( LPSTR pszFileName );
BOOL   GetHomeDirectory   ( LPSTR pszHomeDir );
void   GetFolderPath      ( LPSTR pszPathName, LPSTR pszFileName );
LPCSTR GetRomInfo         ( LPSTR pszFileName, enum RomType rtType );
HWND   FindAppWindow      ( void );
BOOL   AllocMonitorConsole( FILE **pOutput, FILE **pInput );
void   FreeMonitorConsole ( void );
BOOL   GetSystemVersion   ( UINT *pSystemInfo );
int    DisplayMessage     ( HWND hWnd, UINT uMessage, UINT uCaption, UINT uType, ... );
BOOL   ExecuteCmd         ( LPSTR pszCommand, BOOL bGetOutput );
BOOL   ExecutePrintCmd    ( LPSTR pszPrintFile );
void   RefreshViewBounds  ( BOOL bClipCursor );

/* Exported globals */

extern const int g_nRomTypeInfoNo;

extern struct RomTypeInfo_t g_aRomTypeInfo[];
extern char   g_szSystemDesc              [];

extern UINT   g_unSystemInfo;
extern int    g_nPalFreq;
extern int    g_nNtscFreq;

extern LPCSTR TITLE_STOPPED;
extern LPCSTR TITLE_NOTRUN;
extern LPCSTR TITLE_PAUSED;
extern LPCSTR TITLE_FAILURE;
extern LPCSTR TITLE_MONITOR;


#ifdef __cplusplus
}
#endif

#endif /*__MISC_WIN_H__*/
