/****************************************************************************
File    : DriveDlg.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Interface of the CDriveDlg class
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 15.10.2000
*/

#ifndef __DRIVEDLG_H__
#define __DRIVEDLG_H__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


/////////////////////////////////////////////////////////////////////////////
// CDriveDlg dialog

class CDriveDlg : public CDialog
{
// Type definitions
public:
	struct DiskData_t
	{
		LPSTR      pszName;
		char       szNewName[ MAX_PATH ];
		UINT       nButtonID;
		UINT       nEditID;
		UINT       nComboID;
		UnitStatus usStatus;
	};

// Construction
public:
	CDriveDlg( CWnd *pParent = NULL );   // standard constructor

// Interface: operations
public:

// Interface: attributes
public:

// Dialog Data
	//{{AFX_DATA(CDriveDlg)
	enum { IDD = IDD_DRIVE };
	//}}AFX_DATA

// Implementation: operations
private:
	void       SetDlgState       ();
	void       ReceiveFocused    ();
	BOOL       GetDiskImage      ( int nDrive );
	BOOL       DriveButton       ( UINT nButtonID, HWND hwndButton );
	BOOL       KillfocusEditDrive( UINT nEditID,   HWND hwndEdit );
	BOOL       StatusSelChange   ( UINT nComboID,  HWND hwndCombo );
	UnitStatus CheckSelectedDisk ( LPCSTR pszDiskName, UINT *pInfo = NULL );

// Implementation: overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDriveDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation: attributes
private:
	BOOL        m_bSmallMode;
	DiskData_t *m_pDiskData;

// Generated message map functions
protected:
	//{{AFX_MSG(CDriveDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnClearAll();
	afx_msg void OnNewImage();
	afx_msg void OnSelchangeNumber();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif //__DRIVEDLG_H__
