/****************************************************************************
File    : JoystickDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CJoystickDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 01.10.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "KeysetDlg.h"
#include "WarningDlg.h"
#include "Helpers.h"
#include "JoystickDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_JOYSTICK_FIRST		IDC_JOYSTICK_NAMES
#define IDC_JOYSTICK_LAST		IDC_JOYSTICK_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CJoystickDlg dialog

BEGIN_MESSAGE_MAP(CJoystickDlg, CDialog)
	//{{AFX_MSG_MAP(CJoystickDlg)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_PORTNAMES, OnSelchangePortNames)
	ON_CBN_SELCHANGE(IDC_JOYSTICK_NAMES, OnSelchangeJoystickNames)
	ON_BN_CLICKED(IDC_JOYSTICK_KEYSET_A, OnJoystickKeysetA)
	ON_BN_CLICKED(IDC_JOYSTICK_KEYSET_B, OnJoystickKeysetB)
	ON_BN_CLICKED(IDC_JOYSTICK_BUTTONSFIRE, OnButtonsFire)
	ON_BN_CLICKED(IDC_JOYSTICK_RECENTER, OnRecenter)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_JOYSTICK_OK, OnOK)
	ON_BN_CLICKED(IDC_JOYSTICK_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()


CJoystickDlg::CJoystickDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CJoystickDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CJoystickDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void
CJoystickDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CJoystickDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg implementation

/*========================================================
Method   : CHarddiskDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CJoystickDlg::
SetDlgState()
{
	CComboBox	*pJoystick = NULL;
	CSliderCtrl	*pSlider   = NULL;
	CButton	    *pButton   = NULL;

	pJoystick = (CComboBox *)GetDlgItem( IDC_JOYSTICK_NAMES );
	ASSERT(pJoystick);
	/* Keyboard input */
	pJoystick->AddString( "Numpad" );
	pJoystick->AddString( "Arrows + RCtrl as fire" );
	pJoystick->AddString( "Keyset A" );
	pJoystick->AddString( "Keyset B" );
	/* Available input devices */
	for( int i = 0; i < g_nNumDIDevs; i++ )
	{
		pJoystick->AddString( g_acInputDevNames[ i ] );
	}
	/* No input device */
	pJoystick->AddString( "None" );

	if(	(char)m_ucSelectedInputDevice[ 0 ] != NO_JOYSTICK )
	{
		pJoystick->SetCurSel( (char)m_ucSelectedInputDevice[ 0 ] + NUM_KBJOY_DEVICES );
	}
	else
		pJoystick->SetCurSel( g_nNumDIDevs + NUM_KBJOY_DEVICES );

	pJoystick = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORTNAMES );
	ASSERT(pJoystick);
	pJoystick->SetCurSel( 0 );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_RECENTER );
	ASSERT(pButton);
	pButton->SetCheck( (g_ulMiscStates & MS_STICK_RELEASE) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_BUTTONSFIRE );
	ASSERT(pButton);
	pButton->SetCheck( (g_ulMiscStates & MS_JOY_FIRE_ONLY) != 0 );

	pSlider = (CSliderCtrl *)GetDlgItem( IDC_JOYSTICK_REPEATFRAMES );
	ASSERT(pSlider);

	pSlider->SetRange( 0, 10, TRUE );
	pSlider->SetPos( g_nJoyRepeat );
	pSlider = (CSliderCtrl *)GetDlgItem( IDC_JOYSTICK_SKIPFRAMES );
	ASSERT(pSlider);

	pSlider->SetRange( 0, 10, TRUE );
	pSlider->SetPos( g_nJoySkip );
}


/////////////////////////////////////////////////////////////////////////////
// CJoystickDlg message handlers

/*========================================================
Method   : CJoystickDlg::OnInitDialog
=========================================================*/
BOOL
CJoystickDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_ulMiscStates = g_ulMiscStates;

	for( int i = 0; i < MAX_ATARI_JOYPORTS; i++ )
		m_ucSelectedInputDevice[ i ] = (char)g_anSelectedInputDevice[ i ];

	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/*========================================================
Method   : CJoystickDlg::OnSelchangePortNames
=========================================================*/
void
CJoystickDlg::
OnSelchangePortNames()
{
	CComboBox *pJoystick = NULL, *pStickNum = NULL;
	int	nStickNum;

	pJoystick = (CComboBox *)GetDlgItem( IDC_JOYSTICK_NAMES );
	ASSERT(pJoystick);
	pStickNum = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORTNAMES );
	ASSERT(pStickNum);

	if( (nStickNum = pStickNum->GetCurSel()) == CB_ERR )
	{
		pStickNum->SetCurSel( 0 );
		nStickNum = 0;
	}
	if(	(char)m_ucSelectedInputDevice[ nStickNum ] != NO_JOYSTICK )
	{
		pJoystick->SetCurSel( (char)m_ucSelectedInputDevice[ nStickNum ] + NUM_KBJOY_DEVICES );
	}
	else
		pJoystick->SetCurSel( g_nNumDIDevs + NUM_KBJOY_DEVICES );
}

/*========================================================
Method   : CJoystickDlg::OnSelchangeJoystickNames
=========================================================*/
void
CJoystickDlg::
OnSelchangeJoystickNames()
{
	CComboBox *pJoystick = NULL, *pStickNum = NULL;
	int	nStickNum, nJoystick, nPrevJoy;
	int nConflict = -1;
	int i;

	pJoystick = (CComboBox *)GetDlgItem( IDC_JOYSTICK_NAMES );
	ASSERT(pJoystick);
	pStickNum = (CComboBox *)GetDlgItem( IDC_JOYSTICK_PORTNAMES );
	ASSERT(pStickNum);

	if( CB_ERR == (nStickNum = pStickNum->GetCurSel()) )
		return;

	if( CB_ERR == (nJoystick = pJoystick->GetCurSel()) )
		return;

	if( nJoystick > g_nNumDIDevs + NUM_KBJOY_DEVICES - 1  /* Zero based index */ )
		nJoystick = NO_JOYSTICK;
	else
		nJoystick -= NUM_KBJOY_DEVICES;

	nPrevJoy = (char)m_ucSelectedInputDevice[ nStickNum ];

	if( NO_JOYSTICK != nJoystick )
	{
		for( i = 0; i < MAX_ATARI_JOYPORTS; i++ )
		{
			if( (nJoystick == (char)m_ucSelectedInputDevice[ i ]) && i != nStickNum )
				nConflict = i + 1;
		}
	}

	if( nConflict > -1 )
	{
		DisplayMessage( IDS_STICK_CONFLICT, 0, MB_ICONEXCLAMATION | MB_OK, nConflict );
		nJoystick = nPrevJoy;
	}

	m_ucSelectedInputDevice[ nStickNum ] = nJoystick;
	pJoystick->SetCurSel( (NO_JOYSTICK == nJoystick ? g_nNumDIDevs : nJoystick) + NUM_KBJOY_DEVICES );
}

/*========================================================
Method   : CJoystickDlg::OnJoystickKeysetA
=========================================================*/
void
CJoystickDlg::
OnJoystickKeysetA() 
{
	CKeysetDlg dlgKeyset;

	int nResult = IDOK;
	if( !(g_ulDontShowFlags & DONT_SHOW_KBJOY_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARNING_KBJOY, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_KBJOY_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		dlgKeyset.SetTitlePostfix( " A" );
		dlgKeyset.SetCurrentKeyset( KEYS_A_JOYSTICK + NUM_KBJOY_DEVICES );
		dlgKeyset.DoModal();
	}
}

/*========================================================
Method   : CJoystickDlg::OnJoystickKeysetB
=========================================================*/
void
CJoystickDlg::
OnJoystickKeysetB() 
{
	CKeysetDlg dlgKeyset;

	int nResult = IDOK;
	if( !(g_ulDontShowFlags & DONT_SHOW_KBJOY_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARNING_KBJOY, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_KBJOY_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		dlgKeyset.SetTitlePostfix( " B" );
		dlgKeyset.SetCurrentKeyset( KEYS_B_JOYSTICK + NUM_KBJOY_DEVICES );
		dlgKeyset.DoModal();
	}
}

/*========================================================
Method   : CJoystickDlg::OnRecenter
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Recenter check box */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnRecenter()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_RECENTER );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_STICK_RELEASE;
	else
		m_ulMiscStates &= ~MS_STICK_RELEASE;
} /* #OF# CJoystickDlg::OnRecenter */

/*========================================================
Method   : CJoystickDlg::OnButtonsFire
=========================================================*/
/* #FN#
	Sets a state of the object regarding to Don't Assign Buttons check box */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnButtonsFire() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_JOYSTICK_BUTTONSFIRE );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_JOY_FIRE_ONLY;
	else
		m_ulMiscStates &= ~MS_JOY_FIRE_ONLY;
} /* #OF# CJoystickDlg::OnButtonsFire */

/*========================================================
Method   : CJoystickDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CJoystickDlg::
OnOK()
{
	CComboBox	*pStickSel = NULL;
	CSliderCtrl	*pSlider   = NULL;

	BOOL bChanged = FALSE;
	int	 i;

	for( i = 0; i < MAX_ATARI_JOYPORTS; i++ )
	{
		if( (char)m_ucSelectedInputDevice[ i ] != g_anSelectedInputDevice[ i ] )
			bChanged = TRUE;
	}

	g_ulJoystickSelects  = (ULONG)m_ucSelectedInputDevice[ 3 ] << 24;
	g_ulJoystickSelects |= (ULONG)m_ucSelectedInputDevice[ 2 ] << 16;
	g_ulJoystickSelects |= (ULONG)m_ucSelectedInputDevice[ 1 ] << 8;
	g_ulJoystickSelects |= (ULONG)m_ucSelectedInputDevice[ 0 ];

	pSlider = (CSliderCtrl *)GetDlgItem( IDC_JOYSTICK_REPEATFRAMES );
	ASSERT(pSlider);
	g_nJoyRepeat = pSlider->GetPos();

	pSlider = (CSliderCtrl *)GetDlgItem( IDC_JOYSTICK_SKIPFRAMES );
	ASSERT(pSlider );
	g_nJoySkip = pSlider->GetPos();

	if( m_ulMiscStates != g_ulMiscStates )
	{
		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );
	}

	if( bChanged )
	{
		WriteRegDWORD( NULL, REG_JOYSTICKS, g_ulJoystickSelects );
		InitialiseInput();
	}

	CDialog::OnOK();
} /* #OF# CJoystickDlg::OnOK */

BOOL
CJoystickDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_JOYSTICK,
				  IDC_JOYSTICK_FIRST, IDC_JOYSTICK_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
