/****************************************************************************
File    : sound_win.h
/*
@(#) #SY# Atari800Win
@(#) #IS# SoundWin public methods and objects prototypes
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 25.06.2000
*/

#ifndef __SOUND_WIN_H__
#define __SOUND_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Constants declarations */

#define DEFAULT_SOUND_BUFFER_SIZE		4096
#define NUM_SOUND_BUFS					   8
#define SOUND_LATENCY_IN_FRAMES			   2
#define POKEY_UPDATE_DIVISOR_DEFAULT	   2
#define POKEY_SLOP_BYTES				  64

/* Exported methods */

int  InitialiseSound    ( void );
void RestartSound       ( void );
BOOL Sound_VolumeCapable( void );
void Sound_SetVolume    ( void );
void ClearSound         ( BOOL bPermanent );
int  DisableSound       ( BOOL bClearSound );
void OpenSndOutput      ( char *pszOutFileName );
void CloseSndOutput     ( void );

/* Exported globals */

extern BOOL  g_bTimerRollover;
extern FILE *g_pfSndOutput;

extern void (*Atari_PlaySound)(void);

#ifdef __cplusplus
}
#endif

#endif /*__SOUND_WIN_H__*/
