/****************************************************************************
File    : globals.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Shared C-core attributes declarations
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 01.10.2000
*/

#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Shared C-core specific const definitions */

#define ATARI_HORZ_CLIP					24
#define ATARI_FULL_HORZ_CLIP			(ATARI_HORZ_CLIP * 2)
#define ATARI_VIS_WIDTH					(ATARI_WIDTH - ATARI_FULL_HORZ_CLIP)
#define ATARI_STRETCH_VIS_WIDTH			(ATARI_WIDTH * 2 - (ATARI_FULL_HORZ_CLIP *2))
#define ATARI_STRETCH_WIDTH				(ATARI_WIDTH * 2)
#define ATARI_STRETCH_HEIGHT			(ATARI_HEIGHT * 2)

#define ATARI_SCREEN_SIZE				(ATARI_WIDTH * ATARI_HEIGHT)
#define ATARI_VIS_SCREEN_SIZE			(ATARI_VIS_WIDTH * ATARI_HEIGHT)
#define ATARI_STRETCH_VIS_SCREEN_SIZE	(ATARI_STRETCH_VIS_WIDTH * ATARI_STRETCH_HEIGHT)

/* States for the available mode test */
#define MODE_1024_768				0x0080
#define MODE_800_600				0x0040
#define MODE_640_480				0x0020
#define MODE_640_400				0x0010
#define MODE_512_384				0x0008
#define MODE_400_300				0x0004
#define MODE_320_240				0x0002
#define MODE_320_200				0x0001

/* AtariWin display states */
#define SM_FRES_320_200			0x00000001	/* Full screen resolutions */
#define SM_FRES_320_240			0x00000002
#define SM_FRES_400_300			0x00000004
#define SM_FRES_512_384			0x00000008
#define SM_FRES_640_400			0x00000010
#define SM_FRES_640_480			0x00000020
#define SM_FRES_800_600			0x00000040
#define SM_FRES_1024_768		0x00000080
#define SM_FRES_MASK			0x000000FF

#define SM_WRES_NORMAL			0x00000100	/* Windowed resolutions */
#define SM_WRES_STRETCH			0x00000200
#define SM_WRES_MASK			0x00000F00
											/* General display modes */
#define SM_MODE_WIND			0x00001000	/* DirectDraw or GDI windowed mode */
#define SM_MODE_FULL			0x00002000	/* DirectDraw Full screen mode */
#define SM_MODE_MASK			0x0000F000

#define SM_ATTR_SMALL_DLG		0x00010000	/* Display mode attributes */
#define SM_ATTR_NO_MENU			0x00020000
#define SM_ATTR_SCANLINE_CAP	0x00040000
#define SM_ATTR_MASK			0x000F0000

#define SM_OPTN_DDBLT_WAIT		0x00100000	/* Display options */
#define SM_OPTN_DDVBL_WAIT 		0x00200000
#define SM_OPTN_SHOW_SCANLINES	0x00400000
#define SM_OPTN_USE_VIDEOMEM	0x00800000
#define SM_OPTN_USE_GDI			0x01000000
#define SM_OPTN_FLIP_BUFFERS	0x02000000
#define SM_OPTN_HIDE_CURSOR		0x04000000
#define SM_OPTN_MASK			0x0FF00000

#define SM_DDFX_MIRRORLEFTRIGHT	0x10000000	/* FX effects for blits */
#define SM_DDFX_MIRRORUPDOWN	0x20000000
#define SM_DDFX_NOTEARING 		0x40000000
#define SM_DDFX_MASK			0xF0000000

#define DISPLAY_MODE_DEFAULT (SM_MODE_WIND | SM_FRES_640_480 | SM_WRES_NORMAL | SM_OPTN_USE_GDI)

/* Various machine states the Atari can be in */
#define ATARI_UNINITIALIZED			0x0001
#define ATARI_RUNNING				0x0002
#define ATARI_PAUSED				0x0004
#define ATARI_NOFOCUS				0x0008
#define ATARI_LOAD_WARNING			0x0010
#define ATARI_CRASHED				0x0020
#define ATARI_CLOSING				0x0040
#define ATARI_MONITOR               0x0080

/* Misc states to be saved out to the Registry */
#define MS_FULL_SPEED				0x0001
#define MS_AUTO_REG_FILES			0x0002
#define MS_LAST_BOOT_FAILED			0x0004
#define MS_MOUSE_CAPTURED			0x0008
#define MS_STICK_RELEASE			0x0010
#define MS_USE_KEY_TEMPLATE			0x0020
#define MS_RAMBO_MODE				0x0040
#define MS_USE_EXT_PALETTE			0x0080
#define MS_SHOW_PEN_POINTER			0x0100
#define MS_JOY_FIRE_ONLY			0x0200
#define MS_MULTIPLE_INSTANCES		0x0400
#define MS_CAPTURE_CTRLESC			0x0800
#define MS_USE_DOUBLE_REFRESH		0x1000

/* Sound states and registry stuff */
#define SOUND_MMSOUND				0x0001
#define SOUND_DIRECTSOUND			0x0002
#define SOUND_CUSTOM_RATE			0x0004
#define SOUND_NOSOUND				0x0008

/* "Don't show" warning flags */
#define DONT_SHOW_GRAPHICS_WARN		0x0001
#define DONT_SHOW_SOUNDFILE_WARN	0x0002
#define DONT_SHOW_MENU_WARN			0x0004
#define DONT_SHOW_OSA_WARN			0x0008
#define DONT_SHOW_OSB_WARN			0x0010
#define DONT_SHOW_XL_WARN			0x0020
#define DONT_SHOW_5200_WARN			0x0040
#define DONT_SHOW_BASIC_WARN		0x0080
#define DONT_SHOW_VBLWAIT_WARN		0x0100
#define DONT_SHOW_KBJOY_WARN		0x0200

/* File associations registry flags */
#define FILE_ATR					0x0001
#define FILE_XFD					0x0002
#define FILE_DCM					0x0004
#define FILE_ATZ					0x0008
#define FILE_XFZ					0x0010
#define FILE_XEX					0x0020
#define FILE_ROM					0x0040
#define FILE_BIN					0x0080
#define FILE_CRT					0x0100
#define FILE_A8S					0x0200

/* Mouse emulating modes */
#define MOUSE_OFF					0
#define MOUSE_PAD					1	/* Touch tablet, paddles */
#define MOUSE_PEN					2	/* Light pen, light gun */
#define MOUSE_AMIGA					3	/* Amiga mouse */
#define MOUSE_ST					4	/* Atari ST mouse */
#define MOUSE_JOY					5	/* Joystick */

/* Miscellanous constants */
#define SLEEP_TIME_IN_MS			5
#define LOADSTRING_STRING_SIZE		1024
#define ROM_TYPES_NO				5

/* AtariWin C modules shared objects */

extern LPCSTR DEFAULT_A8K;
extern LPCSTR DEFAULT_A8S;
extern LPCSTR DEFAULT_ACT;
extern LPCSTR DEFAULT_OSA;
extern LPCSTR DEFAULT_OSB;
extern LPCSTR DEFAULT_OXL;
extern LPCSTR DEFAULT_O52;
extern LPCSTR DEFAULT_BAS;

extern HWND   g_hMainWnd;
extern HWND   g_hViewWnd;
extern int    g_nStartX;
extern int    g_nStartY;
extern long   g_nSleepThreshold;
extern int    g_nJoyRepeat;
extern int    g_nJoySkip;
extern int    g_nSoundRate;
extern int    g_nSoundVol;
extern int    g_nSkipUpdateDefault;
extern int    g_nUseVolumeOnly;
extern int    g_nShowCursor;
extern int    g_nTestVal;
extern int    g_nMouseMode;
extern int    g_nMouseButtons;
extern int    g_nMouseX;
extern int    g_nMouseY;
extern int    g_nPenOffsetX;
extern int    g_nPenOffsetY;
extern int    g_nMousePort;
extern int    g_nMouseSpeed;
extern int    g_nPaddleRange;
extern int    g_nJoystickInertia;
extern int    g_nStretchedRate;
extern int    g_nSpeedPercent;

extern RECT   g_rcViewBounds;

extern ULONG  g_ulScreenMode;
extern ULONG  g_ulModesAvail;
extern ULONG  g_ulMiscStates;
extern ULONG  g_ulDontShowFlags;
extern ULONG  g_ulAtariHWNextTime;
extern ULONG  g_ulDeltaT;
extern ULONG  g_ulJoystickSelects;
extern ULONG  g_ulSoundState;
extern ULONG  g_ulAtariState;
extern ULONG  g_ulFileAssociations;

/* Bitmap info for our screen bitmap */
extern LPBITMAPINFO g_lpbmi;

extern int   g_argc;
extern char *g_argv          [];
extern char  g_szCmdLine     [];

extern char *g_apszDriveRegID[];
extern char  g_szCurrentRom  [];
extern char  g_szOtherRom    [];
extern char  g_szTemplateFile[];
extern char  g_szTemplateDesc[];
extern char  g_szPaletteFile [];
extern int   g_nKBTable      []; /* Number of virtual key codes */

extern PALETTEENTRY g_pe     [];

/* AtariWin C modules struct definitions */

struct Header_t
{
	UBYTE ubId      [ 4 ];
	UBYTE ubType    [ 4 ];
	UBYTE ubCheckSum[ 4 ];
	UBYTE ubGash    [ 4 ];
};

/* Some usefull aliases */

#define ST_DOUBLE_REFRESH \
	(g_ulMiscStates & MS_USE_DOUBLE_REFRESH && \
	 g_ulScreenMode & SM_MODE_WIND && \
	 g_ulScreenMode & SM_WRES_STRETCH)

#define ST_MENUBAR_HIDDEN \
	(g_ulScreenMode & (SM_OPTN_FLIP_BUFFERS | SM_ATTR_NO_MENU))


#ifdef __cplusplus
}
#endif

#endif /*__GLOBALS_H__*/
