/****************************************************************************
File    : Helpers.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Global helpers declaration
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 29.09.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __HELPERS_H__
#define __HELPERS_H__

/* Windows key codes */

#define SHFT	AKEY_SHFT
#define CTRL	AKEY_CTRL
#define CSFT	AKEY_SHFT | AKEY_CTRL
#define SPECIAL	SPECIAL_HANDLER_MASK

extern int g_iNormKeys    [];
extern int g_iShftKeys    [];
extern int g_iCtrlKeys    [];
extern int g_iShftCtrlKeys[];
extern int g_iToggleKeys  [];

/* File management */

#define PF_LOAD_FLAGS	(OFN_EXPLORER | OFN_HIDEREADONLY | OFN_FILEMUSTEXIST)
#define PF_SAVE_FLAGS	(OFN_EXPLORER | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT)

extern LPCSTR  PF_DSK_FILTER;
extern LPCSTR  PF_BIN_FILTER;
extern LPCSTR  PF_A8S_FILTER;
extern LPCSTR  PF_A8K_FILTER;
extern LPCSTR  PF_ACT_FILTER;
extern LPCSTR  PF_PCX_FILTER;
extern LPCSTR  PF_WAV_FILTER;
extern LPCSTR  PF_CRT_FILTER;
extern LPCSTR  PF_ROM_FILTER;
extern LPCSTR  PF_CAR_FILTER;
extern LPCSTR  PF_DCM_FILTER;

BOOL PickFileName( BOOL bOpenFileDialog, LPSTR pszFileName, LPCSTR pszTitle, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None" );
BOOL PickFileName( BOOL bOpenFileDialog, CString &strFileName, LPCSTR pszTitle, LPCSTR pszFilter, LPCSTR pszDefExt, DWORD dwFlags, BOOL bCheckPath = TRUE, LPCSTR pszNoneFile = "None" );

/* Cartridge management */

BOOL PickCartridge  ( LPSTR pszCurrentCart );
BOOL AttachCartridge( LPSTR pszCartridge, int nCartType );

/* Hooks procedures */

UINT CALLBACK FileDialogHookProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );

/* Help support */

void HelpInfo( HELPINFO *pHelpInfo, HWND hDlgWnd, UINT nDlgWnd, UINT nFirstCtrl, UINT nLastCtrl );

/* Miscellanous */

void RestartEmulation    ( BOOL bForceWinInit = TRUE, BOOL bIgnoreParams = TRUE );
void DescribeAtariSystem ( BOOL bForceShow = FALSE, int nSpeed = -1 );
void RefreshViewBounds   ( void );
void ShowEmulatorSpeed   ( BOOL bForceShow, int nSpeed = -1 );

extern BOOL g_bLargeFonts;

#endif /*__HELPERS_H__*/
