/****************************************************************************
File    : KeyboardDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CKeyboardDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 27.04.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "FileSmallDlg.h"
#include "KeyboardDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


unsigned char g_aucKeysCovered[ 256 ] =
{
	/*  0*/	0, 0, 0, 0, 0, 0, 0, 0,	// BACKSPACE
	/*  8*/	1, 1, 0, 0, 0, 1, 0, 0, // TAB RET
	/* 16*/	0, 0, 0, 0, 1, 0, 0, 0, // CAPS LOCK
	/* 24*/	0, 0, 0, 1, 0, 0, 0, 0, // ESC SPACE
	/* 32*/ 1, 0, 0, 0, 0, 1, 1, 1, // LEFT UP RIGHT DOWN
	/* 40*/	1, 0, 0, 0, 0, 0, 0, 0, // 0
	/* 48*/	1, 1, 1, 1, 1, 1, 1, 1, // 1 2 3 4 5 6 7 8
	/* 56*/	1, 1, 0, 0, 0, 0, 0, 0, // 9 
	/* 64*/	0, 1, 1, 1, 1, 1, 1, 1, // a b c d e f g h
	/* 72*/	1, 1, 1, 1, 1, 1, 1, 1, // i j k l m n o p 
	/* 80*/	1, 1, 1, 1, 1, 1, 1, 1, // q r s t u v w x 
	/* 88*/	1, 1, 1, 0, 0, 0, 0, 0, // y z PAD0
	/* 96*/	1, 1, 1, 1, 1, 1, 1, 1, // PAD1 PAD2 PAD3 PAD4 PAD5 PAD6 PAD7 PAD8
	/*104*/	1, 1, 1, 1, 0, 1, 1, 1, // PAD9 PAD* PAD+ PAD- PAD. PAD/
	/*112*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*120*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*128*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*136*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*144*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*152*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*160*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*168*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*176*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*184*/	0, 0, 1, 1, 1, 1, 1, 1, 
	/*192*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*200*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*208*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*216*/	0, 0, 0, 1, 1, 1, 1, 0, 
	/*224*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*232*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*240*/	0, 0, 0, 0, 0, 0, 0, 0, 
	/*248*/	0, 0, 0, 0, 0, 0, 0, 0
};

/////////////////////////////////////////////////////////////////////////////
// Static objects

static const int s_nAKeyVals[ NUM_ATARI_KEY_ELEMENTS ] =
{
	AKEY_ESCAPE,  AKEY_1,		  AKEY_2,	  AKEY_3,		 AKEY_4,		  AKEY_5,	 // ESC 1 2 3 4 5
	AKEY_6,		  AKEY_7,		  AKEY_8,	  AKEY_9,		 AKEY_0,		  AKEY_LESS, // 6 7 8 9 0 <
	AKEY_GREATER, AKEY_BACKSPACE, AKEY_TAB,	  AKEY_q,		 AKEY_w,		  AKEY_e,	 // > BACKSPC TAB q w e
	AKEY_r,		  AKEY_t,		  AKEY_y,	  AKEY_u,		 AKEY_i,		  AKEY_o,	 // r t y u i o 
	AKEY_p,		  AKEY_MINUS,	  AKEY_EQUAL, AKEY_RETURN,	 AKEY_a,		  AKEY_s,	 // p - = RET a s
	AKEY_d,		  AKEY_f,		  AKEY_g,	  AKEY_h,		 AKEY_j,		  AKEY_k,	 // d f g h j k
	AKEY_l,		  AKEY_SEMICOLON, AKEY_PLUS,  AKEY_ASTERISK, AKEY_CAPSTOGGLE, AKEY_z,	 // l ; + * CAPS z
	AKEY_x,		  AKEY_c,		  AKEY_v,	  AKEY_b,		 AKEY_n,		  AKEY_m,	 // x c v b n m 
	AKEY_COMMA,	  AKEY_FULLSTOP,  AKEY_SLASH, AKEY_ATARI,	 AKEY_SPACE,	  AKEY_NONE	 // , . / ATARI SPC NONE
};

static const int s_nPCKeyVals[ NUM_PC_KEY_ELEMENTS ] =
{
	VK_ESCAPE,	0xc0,		0x31,		0x32,		0x33,			0x34,			// ESC ` 1 2 3 4
	0x35,		0x36,		0x37,		0x38,		0x39,			0x30,			// 5 6 7 8 9 0 
	0xbd,		0xbb,		VK_BACK,	VK_TAB,		0x51,			0x57,			// - = BACKSPC TAB Q W
	0x45,		0x52,		0x54,		0x59,		0x55,			0x49,			// E R T Y U I 
	0x4f,		0x50,		0xdb,		0xdd,		0xdc,			VK_CAPITAL,		// O P [ ] BACKSLASH CAPSLOCK
	0x41,		0x53,		0x44,		0x46,		0x47,			0x48,			// A S D F G H
	0x4a,		0x4b,		0x4c,		0xba,		0xde,			VK_RETURN,		// J K L ; ' ENTER
	0x5a,		0x58,		0x43,		0x56,		0x42,			0x4e,			// Z X C V B N
	0x4d,		0xbc,		0xbe,		0xbf,		VK_SPACE,		VK_UP,			// M , . / SPACE UP
	VK_LEFT,	VK_DOWN,	VK_RIGHT,	VK_DIVIDE,	VK_MULTIPLY,	VK_SUBTRACT,	// LEFT DOWN RIGHT / * -
	VK_NUMPAD7,	VK_NUMPAD8,	VK_NUMPAD9,	VK_NUMPAD4,	VK_NUMPAD5,		VK_NUMPAD6,		// 7 8 9 4 5 6 
	VK_NUMPAD1,	VK_NUMPAD2,	VK_NUMPAD3,	VK_ADD,		VK_NUMPAD0,		VK_DECIMAL		// 1 2 3 + 0 .
};

static const int s_nKBDefault[ NUM_PC_KEY_ELEMENTS ] =
{
	AKEY_ESCAPE,	AKEY_NONE,		AKEY_1,			AKEY_2,			AKEY_3,			AKEY_4,			// ESC ` 1 2 3 4
	AKEY_5,			AKEY_6,			AKEY_7,			AKEY_8,			AKEY_9,			AKEY_0,			// 5 6 7 8 9 0 
	AKEY_MINUS,		AKEY_EQUAL,		AKEY_BACKSPACE,	AKEY_TAB,		AKEY_q,			AKEY_w,			// - = BACKSPC TAB Q W
	AKEY_e,			AKEY_r,			AKEY_t,			AKEY_y,			AKEY_u,			AKEY_i,			// E R T Y U I 
	AKEY_o,			AKEY_p,			AKEY_PLUS,		AKEY_ASTERISK,	AKEY_NONE,		AKEY_CAPSTOGGLE,// O P [ ] BACKSLASH CAPSLOCK
	AKEY_a,			AKEY_s,			AKEY_d,			AKEY_f,			AKEY_g,			AKEY_h,			// A S D F G H
	AKEY_j,			AKEY_k,			AKEY_l,			AKEY_SEMICOLON,	AKEY_NONE,		AKEY_RETURN,	// J K L ; ' ENTER
	AKEY_z,			AKEY_x,			AKEY_c,			AKEY_v,			AKEY_b,			AKEY_n,			// Z X C V B N
	AKEY_m,			AKEY_COMMA,		AKEY_FULLSTOP,	AKEY_SLASH,		AKEY_SPACE,		AKEY_UP,		// M , . / SPACE UP
	AKEY_LEFT,		AKEY_DOWN,		AKEY_RIGHT,		AKEY_SLASH,		AKEY_ASTERISK,	AKEY_MINUS,		// LEFT DOWN RIGHT / * -
	AKEY_7,			AKEY_8,			AKEY_9,			AKEY_4,			AKEY_5,			AKEY_6,			// 7 8 9 4 5 6 
	AKEY_1,			AKEY_2,			AKEY_3,			AKEY_PLUS,		AKEY_0,			AKEY_FULLSTOP	// 1 2 3 + 0 .
};


/////////////////////////////////////////////////////////////////////////////
// CKeyboardDlg dialog

BEGIN_MESSAGE_MAP(CKeyboardDlg, CDialog)
	//{{AFX_MSG_MAP(CKeyboardDlg)
	ON_CBN_SELCHANGE(IDC_KEYBOARD_PCKEYS, OnSelchangePcKeys)
	ON_CBN_SELCHANGE(IDC_KEYBOARD_A8KEYS, OnSelchangeAtariKeys)
	ON_BN_CLICKED(IDC_KEYBOARD_CTRL, OnCtrl)
	ON_BN_CLICKED(IDC_KEYBOARD_SHIFT, OnShift)
	ON_BN_CLICKED(IDC_KEYBOARD_SAVETEMPLATE, OnSaveTemplate)
	ON_BN_CLICKED(IDC_KEYBOARD_LOADTEMPLATE, OnLoadTemplate)
	ON_BN_CLICKED(IDC_KEYBOARD_USETEMPLATE, OnUseTemplate)
	ON_EN_KILLFOCUS(IDC_KEYBOARD_TEMPLATEDESC, OnKillfocusTemplateDesc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CKeyboardDlg::
CKeyboardDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CKeyboardDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CKeyboardDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void
CKeyboardDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CKeyboardDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BOOL
ReadKeyTemplate( char *pszFileName )
{
	BOOL bResult = TRUE;
	int  iFile;

	iFile = open( pszFileName, O_RDONLY | O_BINARY, 0777 );
	if( iFile != -1 )
	{
		unsigned char cData;
		char szTag[ 4 ];

		szTag[ 3 ] = 0;
		if( read( iFile, &szTag, 3 ) == -1 )
			bResult = FALSE;

		if( strcmp( szTag, "A8K" ) )
			MessageBox( NULL, "Not an Atari keyboard template file", "Atari800Win", MB_ICONEXCLAMATION | MB_OK );
		else
		{
			if( (read( iFile, &cData, 1 ) == -1) || cData != KEYBOARD_TEMPLATE_VERSION )
				MessageBox( NULL, "Incorrect/old version of template file", "Atari800Win", MB_ICONEXCLAMATION | MB_OK );
			else
			{
				if( read( iFile, &cData, 1 ) == -1 )
					bResult = FALSE;
				else
				{
					if( read( iFile, g_szTemplateDesc, cData) == -1 )
						bResult = FALSE;
					else
					{
						g_szTemplateDesc[ cData ] = 0;
						if( read( iFile, g_nKBTable, 256 * sizeof(int) ) == -1 )
							bResult = FALSE;
					}
				}
			}
		}
		close( iFile );
	}
	else
		bResult = FALSE;

	return bResult;
}

BOOL
SaveKeyTemplate( char *pszFileName )
{
	BOOL bResult = TRUE;
	int  iFile;

	iFile = open( pszFileName, O_CREAT | O_RDWR | O_TRUNC | O_BINARY, 0777 );
	if( iFile != -1 )
	{
		unsigned char ucData = KEYBOARD_TEMPLATE_VERSION;

		if( write( iFile, "A8K", 3 ) == -1 )
			bResult = FALSE;
		else
		{
			if( write( iFile, &ucData, 1 ) == -1 )
				bResult = FALSE;
			else
			{
				ucData = strlen( g_szTemplateDesc );
				if( write( iFile, &ucData, 1 ) == -1 )
					bResult = FALSE;
				else
				{
					if( write( iFile, g_szTemplateDesc, ucData) == -1 )
						bResult = FALSE;
					else
					{
						if( write( iFile, g_nKBTable, 256 * sizeof(int) ) == -1 )
							bResult = FALSE;
					}
				}
			}
		}
		close( iFile );
	}
	else
		bResult = FALSE;
	
	return bResult;
}

/////////////////////////////////////////////////////////////////////////////
// CKeyboardDlg message handlers

void
CKeyboardDlg::
SetDlgState( void )
{
	CComboBox *pComboBox = NULL;
	CButton	  *pButton   = NULL;
	int		   nAKeyTmp;
	char	   szBuffer[ 4 ];

	pComboBox = (CComboBox *)GetDlgItem( IDC_KEYBOARD_PCKEYS );
	ASSERT(pComboBox);
	pComboBox->SetCurSel( m_iPCSelect );
	
	pComboBox = (CComboBox *)GetDlgItem( IDC_KEYBOARD_A8KEYS );
	ASSERT(pComboBox);
	pComboBox->SetCurSel( m_iASelect );

	pButton = (CButton *)GetDlgItem( IDC_KEYBOARD_CTRL );
	ASSERT(pButton);

	if( (g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] != AKEY_NONE) &&
		(g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] & AKEY_CTRL) )
		pButton->SetCheck( 1 );
	else
		pButton->SetCheck( 0 );

	pButton = (CButton *)GetDlgItem( IDC_KEYBOARD_SHIFT );
	ASSERT(pButton);
	if( (g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] != AKEY_NONE) &&
		(g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] & AKEY_SHFT) )
		pButton->SetCheck( 1 );
	else
		pButton->SetCheck( 0 );

	sprintf( szBuffer, "%3d", s_nPCKeyVals[ m_iPCSelect ] );
	SetDlgItemText( IDC_KEYBOARD_VIRTKEY, szBuffer );

	nAKeyTmp = s_nAKeyVals[ m_iASelect ];
	
	if( g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] & AKEY_CTRL )
		nAKeyTmp |= AKEY_CTRL;

	if( g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] & AKEY_SHFT )
		nAKeyTmp |= AKEY_SHFT;

	if( g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] == AKEY_NONE )
		sprintf( szBuffer, "%s", "N/A" );
	else
		sprintf( szBuffer, "%3d", nAKeyTmp );
	SetDlgItemText( IDC_KEYBOARD_ICODE, szBuffer );

	SetDlgItemText( IDC_KEYBOARD_TEMPLATEDESC, g_szTemplateDesc );

	pButton = (CButton *)GetDlgItem( IDC_KEYBOARD_USETEMPLATE );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulMiscStates & MS_USE_KEYTEMPLATE) != 0 );
}

void
CKeyboardDlg::
SetAtariSelect( void )
{
	for( int i = 0; i < NUM_ATARI_KEY_ELEMENTS; i++ )
	{
		if( s_nAKeyVals[ i ] == (g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] & ~(AKEY_SHFT | AKEY_CTRL)) )
			m_iASelect = i;
	}
}

void
CKeyboardDlg::
SetDefaultKeyboard( void )
{
	int i;
	for( i = 0; i < 256; i++ )
		g_nKBTable[ i ] = AKEY_NONE;

	for( i = 0; i < NUM_PC_KEY_ELEMENTS; i++ )
		g_nKBTable[ s_nPCKeyVals[ i ] ] = s_nKBDefault[ i ];

	strcpy( g_szTemplateDesc, "Default Atari-style layout" );

	if( strcmp( g_szTemplateFile, DEFAULT_A8K ) != 0 )
	{
		strncpy( g_szTemplateFile, DEFAULT_A8K, MAX_PATH );
		WriteRegString( NULL, REG_KEY_TEMPLATE, g_szTemplateFile );
	}
	/* Reset key state */
	m_ulKeyState = 0L;
}

BOOL
CKeyboardDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ulKeyState   = 0L;
	m_ulMiscStates = g_ulMiscStates;

	/* This will write to Registry as auto-verification of corrupted values */
	if( !(m_ulMiscStates & MS_USE_KEYTEMPLATE) )
		SetDefaultKeyboard();

	m_iPCSelect = m_iASelect = 0;
	SetAtariSelect();
	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CKeyboardDlg::
OnSelchangePcKeys() 
{
	CComboBox *pComboBox = (CComboBox *)GetDlgItem( IDC_KEYBOARD_PCKEYS );
	ASSERT(pComboBox);

	m_iPCSelect = pComboBox->GetCurSel();
	if( m_iPCSelect == CB_ERR || m_iPCSelect < 0 || m_iPCSelect > NUM_PC_KEY_ELEMENTS - 1 )
		m_iPCSelect = 0;

	SetAtariSelect();
	SetDlgState();
}

void
CKeyboardDlg::
OnSelchangeAtariKeys() 
{
	CComboBox *pComboBox = (CComboBox *)GetDlgItem( IDC_KEYBOARD_A8KEYS );
	ASSERT(pComboBox);

	m_iASelect = pComboBox->GetCurSel();
	if( m_iASelect == CB_ERR || m_iASelect < 0 || m_iASelect > NUM_ATARI_KEY_ELEMENTS - 1 )
		m_iASelect = 0;

	g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] = s_nAKeyVals[ m_iASelect ];

	m_ulKeyState |= KEY_CHANGED_CONTENTS;
	SetDlgState();
}

void
CKeyboardDlg::
OnCtrl() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_KEYBOARD_CTRL );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] |= AKEY_CTRL;
	else
		g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] &= ~AKEY_CTRL;

	m_ulKeyState |= KEY_CHANGED_CONTENTS;
	SetDlgState();
}

void
CKeyboardDlg::
OnShift() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_KEYBOARD_SHIFT );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] |= AKEY_SHFT;
	else
		g_nKBTable[ s_nPCKeyVals[ m_iPCSelect ] ] &= ~AKEY_SHFT;

	m_ulKeyState |= KEY_CHANGED_CONTENTS;
	SetDlgState();
}

void
CKeyboardDlg::
OnKillfocusTemplateDesc()
{
	GetDlgItemText( IDC_KEYBOARD_TEMPLATEDESC, g_szTemplateDesc, MAX_PATH );
	m_ulKeyState |= KEY_CHANGED_CONTENTS;
}

void
CKeyboardDlg::
OnSaveTemplate() 
{
	CString	strTemplateName = g_szTemplateFile;

	if( PickFileName( FALSE, strTemplateName, "Save Atari keyboard template file",
					  PF_A8K_FILTER, "a8k", PF_SAVE_FLAGS, FALSE ) &&
		!strTemplateName.IsEmpty() )
	{
		if( SaveKeyTemplate( (LPSTR)(LPCSTR)strTemplateName ) )
		{
			strncpy( g_szTemplateFile, strTemplateName, MAX_PATH );
			m_ulKeyState = KEY_SAVED_TEMPLATE;
		}
		else
			MessageBox( "Save keyboard template failed", "Atari800Win", MB_ICONEXCLAMATION | MB_OK );
	}
}

void
CKeyboardDlg::
OnLoadTemplate() 
{
	CString	strTemplateName = g_szTemplateFile;

	if( PickFileName( TRUE, strTemplateName, "Load Atari keyboard template file",
					  PF_A8K_FILTER, "a8k", PF_LOAD_FLAGS, FALSE ) &&
		!strTemplateName.IsEmpty() )
	{
		if( ReadKeyTemplate( (LPSTR)(LPCSTR)strTemplateName ) )
		{
			strncpy( g_szTemplateFile, strTemplateName, MAX_PATH );
			m_ulKeyState = KEY_LOADED_TEMPLATE;
		}
		else
			MessageBox( "Read keyboard template failed", "Atari800Win", MB_ICONEXCLAMATION | MB_OK );
	}
	SetDlgState();
}

void
CKeyboardDlg::
OnUseTemplate() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_KEYBOARD_USETEMPLATE );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_USE_KEYTEMPLATE;
	else
		m_ulMiscStates &= ~MS_USE_KEYTEMPLATE;
}

/*========================================================
Method   : CKeyboardDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the CANCEL button */
void
/* #AS#
   Nothing */
CKeyboardDlg::
OnCancel() 
{
	if( m_ulKeyState & KEY_CHANGED_CONTENTS )
	{
		char *pszMessage;

		if( m_ulMiscStates & MS_USE_KEYTEMPLATE )
			pszMessage = "You have turned on a template that isn't saved. If you want to save it and continue, hit Yes, otherwise hit No and it will be turned off";
		else
			pszMessage = "You have made changes but did not save the template. Would you like to save it now?";

		if( IDYES == MessageBox( pszMessage, "Atari800Win", MB_ICONQUESTION | MB_YESNO ) )
			OnSaveTemplate();

		if( m_ulKeyState & KEY_CHANGED_CONTENTS )
			m_ulMiscStates &= ~MS_USE_KEYTEMPLATE;
	}
	/* Set the keyboard to default if "use template" isn't checked */
	if( !(m_ulMiscStates & MS_USE_KEYTEMPLATE) )
		SetDefaultKeyboard();

	if( m_ulMiscStates != g_ulMiscStates )
	{
		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates);
	}
	if( m_ulKeyState & KEY_LOADED_TEMPLATE || m_ulKeyState & KEY_SAVED_TEMPLATE )
		/* Write the name of template file to registry */
		WriteRegString( NULL, REG_KEY_TEMPLATE, g_szTemplateFile );

	CDialog::OnCancel();
} /* #OF# CKeyboardDlg::OnOK */

