/****************************************************************************
File    : HarddiskDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CHarddiskDlg implementation file
@(#) #BY# Tomasz Szymankowski, Richard Lawrence
@(#) #LM# 04.07.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "FileSmallDlg.h"
#include "HarddiskDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define HD_DRIVES_NO	4

const static int s_anEditCtrls[ HD_DRIVES_NO ] =
{
	IDC_HARDISK_EDITHD1,
	IDC_HARDISK_EDITHD2,
	IDC_HARDISK_EDITHD3,
	IDC_HARDISK_EDITHD4
};

static char *s_apszHdDirs[ HD_DRIVES_NO ] =
{
	atari_h1_dir,
	atari_h2_dir,
	atari_h3_dir,
	atari_h4_dir
};

static char s_acNewHdDirs[ HD_DRIVES_NO ][ MAX_PATH ];


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg dialog

BEGIN_MESSAGE_MAP(CHarddiskDlg, CDialog)
	//{{AFX_MSG_MAP(CHarddiskDlg)
	ON_BN_CLICKED(IDC_HARDISK_HD1, OnHd1)
	ON_BN_CLICKED(IDC_HARDISK_HD2, OnHd2)
	ON_BN_CLICKED(IDC_HARDISK_HD3, OnHd3)
	ON_BN_CLICKED(IDC_HARDISK_HD4, OnHd4)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD1, OnKillfocusHd1Edit)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD2, OnKillfocusHd2Edit)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD3, OnKillfocusHd3Edit)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD4, OnKillfocusHd4Edit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CHarddiskDlg::
CHarddiskDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CHarddiskDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CHarddiskDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void
CHarddiskDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CHarddiskDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CHardDisk message handlers

BOOL
CHarddiskDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	/* Backup HD paths */
	for( int i = 0; i < HD_DRIVES_NO; i++ )
	{
		strncpy( &s_acNewHdDirs[ i ][ 0 ], s_apszHdDirs[ i ], MAX_PATH );
		SetDlgItemText( s_anEditCtrls[ i ], &s_acNewHdDirs[ i ][ 0 ] );
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CHarddiskDlg::
SetToDrive( int nDriveIndex )
{
	char   *pszDrivePath = &s_acNewHdDirs[ nDriveIndex ][ 0 ];
	CString	strPath = pszDrivePath;
	int	    nResult;

	CFileSmallDlg dlgFileSmall( NULL, strPath, TRUE );;
	if( IDOK == (nResult = dlgFileSmall.DoModal()) )
	{
		strPath = dlgFileSmall.GetPathName();
		if( strPath.IsEmpty() )
			strPath = ".";
		strcpy( pszDrivePath, strPath );
		if( pszDrivePath[ strlen( pszDrivePath ) - 1 ] == '\\' )
			pszDrivePath[ strlen( pszDrivePath ) - 1 ] = '\0';

		SetDlgItemText( s_anEditCtrls[ nDriveIndex ], pszDrivePath );
	}
}

void
CHarddiskDlg::
OnHd1()
{
	SetToDrive( 0 );
}

void
CHarddiskDlg::
OnHd2()
{
	SetToDrive( 1 );
}

void
CHarddiskDlg::
OnHd3()
{
	SetToDrive( 2 );
}

void
CHarddiskDlg::
OnHd4()
{
	SetToDrive( 3 );
}

void
CHarddiskDlg::
KillfocusHdEdit( int nDriveIndex )
{
	GetDlgItemText( s_anEditCtrls[ nDriveIndex ], &s_acNewHdDirs[ nDriveIndex ][ 0 ], MAX_PATH );
};

void
CHarddiskDlg::
OnKillfocusHd1Edit()
{
	KillfocusHdEdit( 0 );
}

void
CHarddiskDlg::
OnKillfocusHd2Edit()
{
	KillfocusHdEdit( 1 );
}

void
CHarddiskDlg::
OnKillfocusHd3Edit()
{
	KillfocusHdEdit( 2 );
}

void
CHarddiskDlg::
OnKillfocusHd4Edit()
{
	KillfocusHdEdit( 3 );
}

void
CHarddiskDlg::
OnOK()
{
	CWnd *pWnd    = GetFocus();
	int   nCtrlID = pWnd ? pWnd->GetDlgCtrlID() : 0;
	char *apszHdRegs[ HD_DRIVES_NO ] = { REG_HD1, REG_HD2, REG_HD3, REG_HD4 };

	for( int i = 0; i < HD_DRIVES_NO; i++ )
	{
		/* Receive the edit contents again. The user could press 'Enter' or 'Alt-O'
		   and then all changes he's made in the last edited control would be lost */
		if( s_anEditCtrls[ i ] == nCtrlID )
			KillfocusHdEdit( i );

		if( s_acNewHdDirs[ i ][ 0 ] == '\0' )
			strcpy( &s_acNewHdDirs[ i ][ 0 ], "." );

		if( _stricmp( s_apszHdDirs[ i ], &s_acNewHdDirs[ i ][ 0 ] ) != 0 )
		{
			strcpy( s_apszHdDirs[ i ], &s_acNewHdDirs[ i ][ 0 ] );
			WriteRegString( NULL, apszHdRegs[ i ], s_apszHdDirs[ i ] );
		}
	}
	CDialog::OnOK();
}
