/****************************************************************************
File    : DriveSmallDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CDriveSmallDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 03.07.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "DriveSmallDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static objects

static char s_acSioFileName[ MAX_DRIVES ][ MAX_PATH ];


/////////////////////////////////////////////////////////////////////////////
// CDriveSmallDlg dialog

BEGIN_MESSAGE_MAP(CDriveSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CDriveSmallDlg)
	ON_BN_CLICKED(IDC_DRIVE_SMALL_CLEAR, OnDriveClear)
	ON_BN_CLICKED(IDC_DRIVE_SMALL_CHECK, OnDriveCheck)
	ON_BN_CLICKED(IDC_DRIVE_SMALL_FINDFILE, OnDriveFindFile)
	ON_CBN_SELCHANGE(IDC_DRIVE_SMALL_COMBO, OnSelchangeDriveCombo)
	ON_EN_KILLFOCUS(IDC_DRIVE_SMALL_EDIT, OnKillfocusDriveEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CDriveSmallDlg::
CDriveSmallDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CDriveSmallDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CDriveSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void
CDriveSmallDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CDriveSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CDriveSmallDlg message handlers

BOOL
CDriveSmallDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	for( int i = 0; i < MAX_DRIVES; i++ )
		strncpy( s_acSioFileName[ i ], sio_filename[ i ], MAX_PATH );

	if( !(m_pDriveCombo = (CComboBox *)GetDlgItem( IDC_DRIVE_SMALL_COMBO )) )
		return FALSE;

	m_pDriveCombo->SetCurSel( 0 );
	SetDlgItemText( IDC_DRIVE_SMALL_EDIT, s_acSioFileName[ 0 ] );

	if( !(m_pCheckButton = (CButton *)GetDlgItem( IDC_DRIVE_SMALL_CHECK )) )
		return FALSE;

	if( strcmp( s_acSioFileName[ 0 ], "Off" ) != 0 )
		m_pCheckButton->SetCheck( 1 );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CDriveSmallDlg::
OnDriveClear()
{
	for( int i = 0; i < MAX_DRIVES; i++ )
		strcpy( s_acSioFileName[ i ], "Empty" );

	SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Empty" );
}

void
CDriveSmallDlg::
OnDriveCheck()
{
	int	nDrive = m_pDriveCombo->GetCurSel();

	if( CB_ERR == nDrive )
	{
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Not a drive" );
		m_pCheckButton->SetCheck( 0 );
		return;
	}
	if( strcmp( s_acSioFileName[ nDrive ], "Off" ) != 0 )
	{
		strcpy( s_acSioFileName[ nDrive ], "Off" );
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Off" );
		m_pCheckButton->SetCheck( 0 );
	}
	else
	{
		strcpy( s_acSioFileName[ nDrive ], "Empty" );
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Empty" );
		m_pCheckButton->SetCheck( 1 );
	}
}

void
CDriveSmallDlg::
OnSelchangeDriveCombo()
{
	int	nDrive = m_pDriveCombo->GetCurSel();

	if( CB_ERR == nDrive )
	{
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Not a drive" );
		m_pCheckButton->SetCheck( 0 );
		return;
	}

	SetDlgItemText( IDC_DRIVE_SMALL_EDIT, s_acSioFileName[ nDrive ] );
	if( strcmp( s_acSioFileName[ nDrive ], "Off" ) )
		m_pCheckButton->SetCheck( 1 );
	else
		m_pCheckButton->SetCheck( 0 );
}

void
CDriveSmallDlg::
OnDriveFindFile()
{
	char	szPrompt[ 64 ];
	CString	strDiskName;
	int	    nDrive  = m_pDriveCombo->GetCurSel();

	if( CB_ERR == nDrive )
	{
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Not a drive" );
		m_pCheckButton->SetCheck( 0 );
		return;
	}
	sprintf( szPrompt, "Select disk for drive %d", nDrive + 1 );
	strDiskName = s_acSioFileName[ nDrive ];

	if( PickFileName( TRUE, strDiskName, szPrompt,
					  PF_DSK_FILTER, NULL, PF_LOAD_FLAGS ) &&
		!strDiskName.IsEmpty() )
	{
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, (LPSTR)(LPCSTR)strDiskName );
		strncpy( s_acSioFileName[ nDrive ], strDiskName, MAX_PATH );
	}
}

void
CDriveSmallDlg::
OnKillfocusDriveEdit()
{
	int	nDrive = m_pDriveCombo->GetCurSel();

	if( CB_ERR != nDrive )
		GetDlgItemText( IDC_DRIVE_SMALL_EDIT, s_acSioFileName[ nDrive ], MAX_PATH );
}

void
CDriveSmallDlg::
OnOK()
{
	for( int i = 0; i < MAX_DRIVES; i++ )
	{
		if( _stricmp( s_acSioFileName[ i ], sio_filename[ i ] ) != 0 )
		{
			WriteRegString( NULL, g_apszDriveRegID[ i ], sio_filename[ i ] );
			
			if( !strcmp( s_acSioFileName[ i ], "Off" ) )
				SIO_DisableDrive( i + 1 );
			else if( !strcmp( s_acSioFileName[ i ], "Empty" ) )
				SIO_Dismount( i + 1 );
			else
			{
				SIO_Dismount( i + 1 );
				SIO_Mount( i + 1, s_acSioFileName[ i ] );		
			}
		}
	}
	CDialog::OnOK();
}
