/****************************************************************************
File    : globals.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Shared C-core attributes declarations
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 04.07.2000
*/

#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Shared C-core specific const definitions */

#define ATARI_HORZ_CLIP					24
#define ATARI_FULL_HORZ_CLIP			ATARI_HORZ_CLIP * 2
#define ATARI_VIS_WIDTH					(ATARI_WIDTH - ATARI_FULL_HORZ_CLIP)
#define ATARI_STRETCH_VIS_WIDTH			(ATARI_WIDTH * 2 - (ATARI_FULL_HORZ_CLIP *2) )
#define ATARI_STRETCH_WIDTH				(ATARI_WIDTH * 2)
#define ATARI_STRETCH_HEIGHT			(ATARI_HEIGHT * 2)

#define ATARI_SCREEN_SIZE				(ATARI_WIDTH * ATARI_HEIGHT)
#define ATARI_VIS_SCREEN_SIZE			(ATARI_VIS_WIDTH * ATARI_HEIGHT)
#define ATARI_STRETCH_VIS_SCREEN_SIZE	(ATARI_STRETCH_VIS_WIDTH * ATARI_STRETCH_HEIGHT)

/* States for the modes available test */
#define MODE_1024_768			0x0040
#define MODE_800_600			0x0020
#define MODE_640_480			0x0010
#define MODE_640_400			0x0008
#define MODE_512_384			0x0004
#define MODE_320_240			0x0002
#define MODE_320_200			0x0001

/* AtariWin display states */
#define SM_FRES_320_200			0x00000001	/* Full screen resolutions */
#define SM_FRES_320_240			0x00000002
#define SM_FRES_512_384			0x00000004
#define SM_FRES_640_400			0x00000008
#define SM_FRES_640_480			0x00000010
#define SM_FRES_800_600			0x00000020
#define SM_FRES_1024_768		0x00000040
#define SM_FRES_MASK			0x000000FF

#define SM_WRES_NORMAL			0x00000100	/* Windowed resolutions */
#define SM_WRES_STRETCH			0x00000200
#define SM_WRES_MASK			0x00000F00
											/* General display modes */
#define SM_MODE_WIND			0x00001000	/* DirectDraw or GDI windowed mode */
#define SM_MODE_FULL			0x00002000	/* DirectDraw Full screen mode */
#define SM_MODE_MASK			0x0000F000

#define SM_ATTR_SMALL_DLG		0x00010000	/* Display mode attributes */
#define SM_ATTR_NO_MENU			0x00020000
#define SM_ATTR_SCANLINE_CAP	0x00040000
#define SM_ATTR_MASK			0x000F0000

#define SM_OPTN_DDBLT_WAIT		0x00100000	/* Display options */
#define SM_OPTN_DDVBL_WAIT 		0x00200000
#define SM_OPTN_SHOW_SCANLINES	0x00400000
#define SM_OPTN_USE_VIDEOMEM	0x00800000
#define SM_OPTN_USE_GDI			0x01000000
#define SM_OPTN_FLIP_BUFFERS	0x02000000
#define SM_OPTN_HIDE_CURSOR		0x04000000
#define SM_OPTN_MASK			0x0FF00000

#define DISPLAY_MODE_DEFAULT (SM_MODE_WIND | SM_FRES_640_480 | SM_WRES_NORMAL | SM_OPTN_USE_GDI)

/* Various machine states the Atari can be in */
#define ATARI_UNINITIALIZED			0x0001
#define ATARI_RUNNING				0x0002
#define ATARI_PAUSED				0x0004
#define ATARI_NOFOCUS				0x0008
#define ATARI_LOAD_FAILED			0x0010
#define ATARI_LOAD_WARNING			0x0020
#define ATARI_CRASHED				0x0040
#define ATARI_CLOSING				0x0080

/* Misc states to be saved out to the Registry */
#define MS_FULL_SPEED				0x0001
#define MS_LAST_BOOT_FAILED			0x0004
#define MS_STICK_RELEASE			0x0010
#define MS_USE_KEYTEMPLATE			0x0020
#define MS_RAMBO_MODE				0x0040
#define MS_USE_PALETTE				0x0080

/* Sound states and registry stuff */
#define SOUND_MMSOUND				0x0001
#define SOUND_DIRECTSOUND			0x0002
#define SOUND_CUSTOM_RATE			0x0004
#define SOUND_NOSOUND				0x0008

/* "Don't show" warning flags */
#define DONT_SHOW_GRAPHICS_WARN		0x0001
#define DONT_SHOW_SOUNDFILE_WARN	0x0002
#define DONT_SHOW_MENU_WARN			0x0004
#define DONT_SHOW_OSA_WARN			0x0008
#define DONT_SHOW_OSB_WARN			0x0010
#define DONT_SHOW_XL_WARN			0x0020
#define DONT_SHOW_5200_WARN			0x0040
#define DONT_SHOW_BASIC_WARN		0x0080
#define DONT_SHOW_VBLWAIT_WARN		0x0100
#define DONT_SHOW_KBJOY_WARN		0x0200

/* File associations registry flags */
#define FILE_ATR					0x0001
#define FILE_XFD					0x0002
#define FILE_DCM					0x0004
#define FILE_ATZ					0x0008
#define FILE_XFZ					0x0010
#define FILE_XEX					0x0020
#define FILE_ROM					0x0040
#define FILE_BIN					0x0080
#define FILE_CRT					0x0100
#define FILE_A8S					0x0200

/* Miscellanous const */
#define SLEEP_TIME_IN_MS			5
#define LOADSTRING_STRING_SIZE		1024

/* AtariWin C modules shared objects */

extern LPCSTR DEFAULT_A8K;
extern LPCSTR DEFAULT_ACT;
extern LPCSTR DEFAULT_OSA;
extern LPCSTR DEFAULT_OSB;
extern LPCSTR DEFAULT_OXL;
extern LPCSTR DEFAULT_O52;
extern LPCSTR DEFAULT_BAS;

extern HWND   g_hMainWnd;
extern HWND   g_hWnd;
extern int    g_nStartX;
extern int    g_nStartY;
extern long   g_nSleepThreshold;
extern int    g_nJoyRepeat;
extern int    g_nJoySkip;
extern int    g_nSoundRate;
extern int    g_nSoundVol;
extern int    g_nShowCursor;
extern int    g_nTestVal;

extern ULONG  g_ulScreenMode;
extern ULONG  g_ulModesAvail;
extern ULONG  g_ulMiscStates;
extern ULONG  g_ulDontShowFlags;
extern ULONG  g_ulAtariHWNexttime;
extern ULONG  g_ulDeltaT;
extern ULONG  g_ulJoystickSelects;
extern ULONG  g_ulSoundState;
extern ULONG  g_ulAtariState;

/* Bitmap info for our screen bitmap */
extern LPBITMAPINFO g_lpbmi;

extern int	 g_argc;
extern char	*g_argv          [];
extern char	 g_szCmdLine     [];

extern char *g_apszDriveRegID[];
extern char  g_szCurrentRom  [];
extern char  g_szOtherRom    [];
extern char  g_szTemplateFile[];
extern char  g_szTemplateDesc[];
extern char  g_szPaletteFile [];
extern int   g_nKBTable      []; /* Number of virtual key codes */

extern PALETTEENTRY g_pe     [];

extern TCHAR g_tszErrorString[];

/* AtariWin C modules struct definitions */

enum FileType { FEI_DSK = 0, FEI_BIN, FEI_ROM, FEI_CRT, FEI_A8S };

struct FileExtInfo_t
{
	enum  FileType ftType;
	DWORD dwRegFlag;
	int	  nCtrlId;
	char *pszFileExt; /* pointer to static text */
};

struct Header_t
{
	UBYTE ubId      [ 4 ];
	UBYTE ubType    [ 4 ];
	UBYTE ubCheckSum[ 4 ];
	UBYTE ubGash    [ 4 ];
};

#ifdef __cplusplus
}
#endif

#endif /*__GLOBALS_H__*/
